/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import java.util.Arrays;

public class VersionHelper {
    public static final int VERSION_24_09 = VersionHelper.encodeVersion(24, 9, 0);
    public static final int VERSION_24_03 = VersionHelper.encodeVersion(24, 3, 0);
    public static final int VERSION_24_03_1 = VersionHelper.encodeVersion(24, 3, 1);
    public static final int VERSION_23_09 = VersionHelper.encodeVersion(23, 9, 0);
    public static final int VERSION_23_09_1 = VersionHelper.encodeVersion(23, 9, 1);
    public static final int VERSION_14_1_1_2206 = VersionHelper.encodeVersion(14, 1, 1, 2206, 0);
    public static final int VERSION_14_1_1_2206_6 = VersionHelper.encodeVersion(14, 1, 1, 2206, 6);
    public static final int VERSION_14_1_1_2206_7 = VersionHelper.encodeVersion(14, 1, 1, 2206, 7);
    public static final int VERSION_14_1_1_2206_9 = VersionHelper.encodeVersion(14, 1, 1, 2206, 9);
    public static final int VERSION_14_1_2_0 = VersionHelper.encodeVersion(14, 1, 2, 0, 0);
    public static final int VERSION_14_1_1_0 = VersionHelper.encodeVersion(14, 1, 1, 0, 0);
    public static final int VERSION_14_1_1_0_16 = VersionHelper.encodeVersion(14, 1, 1, 0, 16);
    public static final int VERSION_14_1_1_0_17 = VersionHelper.encodeVersion(14, 1, 1, 0, 17);
    public static final int VERSION_12_2_1_4 = VersionHelper.encodeVersion(12, 2, 1, 4, 0);
    public static final int VERSION_12_2_1_4_20 = VersionHelper.encodeVersion(12, 2, 1, 4, 20);
    public static final int VERSION_12_2_1_4_21 = VersionHelper.encodeVersion(12, 2, 1, 4, 21);
    public static final int VERSION_12_2_1_6 = VersionHelper.encodeVersion(12, 2, 1, 6, 0);
    public static final int VERSION_12_2_1_6_6 = VersionHelper.encodeVersion(12, 2, 1, 6, 6);
    public static final int VERSION_12_2_1_6_7 = VersionHelper.encodeVersion(12, 2, 1, 6, 7);

    public static int encodeVersion(int nYear, int nMonth, int nPatch) {
        nPatch = (nMonth > 6 ? 32 : 0) | nPatch & 0x1F;
        return VersionHelper.getVersionPrefix(nYear, nMonth) | (nYear & 0x3F) << 6 | nPatch & 0x3F;
    }

    public static int encodeVersion(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nPatchSetActual = VersionHelper.resolveFusionAppsPatchSet(nMajor, nMinor, nMicro, nPatchSet);
        if (nPatchSetActual > 2000) {
            int nPrefix = VersionHelper.encodeVersion(nMajor, nMinor, nMicro, 0, 0);
            int nYear = nPatchSetActual / 100;
            return nPrefix | (nYear & 0x3F) << 6 | nPatch & 0x3F;
        }
        return (nMajor & 0x3F) << 24 | (nMinor & 0x3F) << 18 | (nMicro & 0x3F) << 12 | (nPatchSetActual & 0x3F) << 6 | nPatch & 0x3F;
    }

    public static int getVersionPrefix(int nYear, int nMonth) {
        if (nYear > 23) {
            return VersionHelper.encodeVersion(15, 0, 0, 0, 0);
        }
        if (nYear == 23) {
            return VersionHelper.encodeVersion(14, 1, 2, 0, 0);
        }
        return VersionHelper.encodeVersion(14, 1, 1, 0, 0);
    }

    public static boolean isCalendarVersion(int nVersion) {
        return nVersion >= 20;
    }

    public static int parseVersion(String sVersion) {
        String sYear;
        if (sVersion == null || sVersion.isEmpty()) {
            return 0;
        }
        int ofSuffix = sVersion.indexOf(" ");
        if (ofSuffix > 0) {
            sVersion = sVersion.substring(0, ofSuffix);
        }
        int INDEX_YEAR = 3;
        int INDEX_MONTH = 4;
        String[] asVersions = sVersion.split("\\.");
        if (asVersions.length == 2 || asVersions.length == 3) {
            int nYear = Integer.parseInt(asVersions[0]);
            int nMonth = Integer.parseInt(asVersions[1]);
            int nPatch = asVersions.length == 3 ? Integer.parseInt(asVersions[2]) : 0;
            return VersionHelper.encodeVersion(nYear, nMonth, nPatch);
        }
        String string = sYear = asVersions.length > 3 ? asVersions[3] : "";
        if (sYear.length() >= 4) {
            asVersions = Arrays.copyOf(asVersions, asVersions.length + 1);
            for (int i = asVersions.length - 2; i > 3; --i) {
                asVersions[i + 1] = asVersions[i];
                asVersions[i] = null;
            }
            asVersions[3] = sYear.substring(0, 2);
            asVersions[4] = sYear.substring(2);
        }
        int[] an = new int[5];
        int c = Math.min(an.length, asVersions.length);
        for (int i = 0; i < c; ++i) {
            try {
                int nVersion = Integer.parseInt(asVersions[i]);
                if (i == 4 && VersionHelper.isCalendarVersion(an[i - 1])) {
                    nVersion = nVersion > 6 ? 32 : 0;
                    nVersion |= i + 1 < asVersions.length ? Integer.parseInt(asVersions[i + 1]) : 0;
                }
                an[i] = Math.min(63, nVersion);
                if (i != 3) continue;
                VersionHelper.resolveFusionAppsPatchSet(an);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return VersionHelper.encodeVersion(an[0], an[1], an[2], an[3], an[4]);
    }

    public static int[] toVersionArray(String sVersion) {
        int nVersion = VersionHelper.parseVersion(sVersion);
        return new int[]{(nVersion & 0x3F000000) >> 24, (nVersion & 0xFC0000) >> 18, (nVersion & 0x3F000) >> 12, (nVersion & 0xFC0) >> 6, nVersion & 0x3F};
    }

    public static String toVersionString(int nVersion, boolean fIncludePrefix) {
        int nYear = (nVersion & 0xFC0) >> 6;
        int nPatch = nVersion & 0x3F;
        String sVersion = (String)(fIncludePrefix || !VersionHelper.isCalendarVersion(nYear) ? ((nVersion & 0x3F000000) >> 24) + "." + ((nVersion & 0xFC0000) >> 18) + "." + ((nVersion & 0x3F000) >> 12) + "." : "") + nYear;
        if (VersionHelper.isCalendarVersion(nYear)) {
            int nPatchActual = nPatch & 0xFFFFFFDF;
            sVersion = sVersion + (fIncludePrefix ? "" : ".");
            sVersion = (nPatch & 0x20) == 0 ? sVersion + (nYear <= 22 ? "06" : "03") : sVersion + (nYear <= 21 ? "12" : "09");
            sVersion = sVersion + "." + nPatchActual;
        } else {
            sVersion = sVersion + "." + nPatch;
        }
        return sVersion;
    }

    public static boolean isVersionCompatible(int nRequired, int nActual) {
        return nRequired <= nActual;
    }

    public static boolean isPatchCompatible(int nRequired, int nActual) {
        return (nRequired & 0xFFFFFFC0) == (nActual & 0xFFFFFFC0) && (nRequired & 0x3F) <= (nActual & 0x3F);
    }

    public static void resolveFusionAppsPatchSet(int[] anVersion) {
        if (anVersion != null && anVersion.length == 5) {
            anVersion[3] = VersionHelper.resolveFusionAppsPatchSet(anVersion[0], anVersion[1], anVersion[2], anVersion[3]);
        }
    }

    public static int resolveFusionAppsPatchSet(int nMajor, int nMinor, int nMicro, int nPatchSet) {
        if (nMajor == 14 && nMinor == 1 && nMicro == 2 && nPatchSet == 24) {
            return 0;
        }
        return nPatchSet;
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            int nExitCode;
            String sVersionOne = args[0];
            String sVersionTwo = args[1];
            int nEncodedOne = VersionHelper.parseVersion(sVersionOne.replace("-", "."));
            int nEncodedTwo = VersionHelper.parseVersion(sVersionTwo.replace("-", "."));
            if (VersionHelper.isVersionCompatible(nEncodedTwo, nEncodedOne)) {
                System.out.println("pass");
                nExitCode = 0;
            } else {
                System.out.println("fail");
                nExitCode = 1;
            }
            if (Boolean.getBoolean("no.exit.code")) {
                nExitCode = 0;
            }
            System.exit(nExitCode);
        }
        System.err.println("Usage:");
        System.err.println("VersionHelper <versionCheck> <versionRequired>");
        System.err.println();
        System.err.println("Displays \"pass\" if <versionCheck> is compatible with <versionRequired>");
        System.err.println("Displays \"fail\" if <versionCheck> is not compatible with <versionRequired>");
        System.err.println();
        System.err.println("Exit code zero, versionCheck is compatible with versionRequired");
        System.err.println("Exit code one, versionCheck is not compatible with versionRequired");
        System.err.println("Exit code two, incorrect version arguments were specified");
        System.err.println();
        System.err.println("If the no.exit.code system property is set to true, the exit code will be zero regardless of a pass or fail.");
        System.err.println();
        System.exit(2);
    }
}

