/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.SubSet;
import com.tangosol.util.WrapperCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UnsafeSubSet<E>
extends SubSet<E> {
    private boolean m_fModified;
    protected final BackingMapManagerContext m_ctx;
    protected final PartitionSet m_parts;
    protected int m_cOrig;

    public UnsafeSubSet(Set<E> set, BackingMapManagerContext ctx, PartitionSet parts) {
        super(new WrapperSet<E>(set));
        this.m_ctx = ctx;
        this.m_parts = parts;
        this.m_cOrig = set.size();
    }

    @Override
    public WrapperSet<E> getOriginal() {
        return (WrapperSet)super.getOriginal();
    }

    @Override
    public void resolve() {
        throw new UnsupportedOperationException("Resolve is not supported by UnsafeSubSet.");
    }

    @Override
    public boolean isModified() {
        return ((WrapperSet)this.getOriginal()).isInitialized() && (this.m_fModified || super.isModified());
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Reset is not supported by UnsafeSubSet.");
    }

    @Override
    public boolean removeAll(Collection col) {
        Set setOrig = this.getOriginal();
        if (this.isModified()) {
            return super.removeAll(col);
        }
        this.m_fModified = true;
        this.resetState(setOrig, this.collectSet(col), false);
        ((WrapperSet)setOrig).initialize();
        return !col.isEmpty();
    }

    @Override
    public boolean retainAll(Collection col) {
        if (this.isModified()) {
            return super.retainAll(col);
        }
        this.m_fModified = true;
        WrapperSet<E> setRetained = new WrapperSet<E>(this.collectSet(col));
        this.resetState(setRetained, null, false);
        return !setRetained.isEmpty();
    }

    @Override
    public int size() {
        Set setMod = this.m_setMod;
        int cMod = setMod == null ? 0 : setMod.size();
        Set setOrig = this.m_setOrig;
        if (this.m_fRetained) {
            return cMod;
        }
        if (setMod == null || setMod.isEmpty()) {
            return setOrig.size();
        }
        int cSize = 0;
        for (Object o : setOrig) {
            if (setMod.contains(o)) continue;
            ++cSize;
        }
        return cSize;
    }

    @Override
    public Object[] toArray() {
        if (this.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty() ? EMPTY_ARRAY : setMod.toArray();
        }
        Set setOrig = this.m_setOrig;
        if (setMod == null || setMod.isEmpty()) {
            return setOrig.toArray();
        }
        int cOrig = setOrig.size();
        if (cOrig > 0) {
            int cEstimate = Math.max(cOrig - setMod.size(), 0);
            ArrayList listObjects = new ArrayList(cEstimate);
            for (Object o : setOrig) {
                if (setMod.contains(o)) continue;
                listObjects.add(o);
            }
            return listObjects.toArray();
        }
        return EMPTY_ARRAY;
    }

    protected Set<E> collectSet(Collection<E> col) {
        PartitionSet parts = this.m_parts;
        BackingMapManagerContext ctx = this.m_ctx;
        HashSet<E> set = Base.newHashSet(col.size());
        for (E key : col) {
            if (!parts.contains(ctx.getKeyPartition(key))) continue;
            set.add(key);
        }
        return set;
    }

    @Override
    protected Set ensureRemoved() {
        try {
            Set set = super.ensureRemoved();
            return set;
        }
        finally {
            this.m_fModified = true;
        }
    }

    @Override
    protected Set ensureRetained() {
        try {
            Set set = super.ensureRetained();
            return set;
        }
        finally {
            this.m_fModified = true;
        }
    }

    protected static class WrapperSet<E>
    extends WrapperCollections.AbstractWrapperSet<E> {
        boolean m_fInitialized;

        protected WrapperSet(Set<E> set) {
            super(set);
        }

        @Override
        protected Set<E> getDelegate() {
            if (!this.isInitialized()) {
                this.initialize();
            }
            return super.getDelegate();
        }

        protected void initialize() {
            this.m_fInitialized = true;
        }

        public boolean isInitialized() {
            return this.m_fInitialized;
        }
    }
}

