/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.Unsafe;

public final class UnsafeBinaryWriteBuffer
extends ByteArrayWriteBuffer {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final ThreadLocal<UnsafeBinaryWriteBuffer> THREAD_BUFFER = ThreadLocal.withInitial(() -> new UnsafeBinaryWriteBuffer(4096));

    public UnsafeBinaryWriteBuffer(int cbCap) {
        super(cbCap);
    }

    public UnsafeBinaryWriteBuffer(int cbCap, int cbMax) {
        super(cbCap, cbMax);
    }

    @Override
    public Binary toBinary() {
        return UNSAFE.newBinary(this.m_ab, 0, this.m_cb);
    }

    public static WriteBuffer get() {
        return THREAD_BUFFER.get();
    }
}

