/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Filter;
import java.util.ArrayList;

public class QueryResult {
    private final PartitionSet m_partitionSet;
    private QueryResult[] m_aPartResult;
    private Object[] m_aoResult;
    private int m_cResults;
    private long m_cbSize = -1L;
    private final Filter<?> m_filterRemaining;
    private final boolean m_fOptimized;

    public QueryResult(PartitionSet partitionSet, Object[] aoResult) {
        this(partitionSet, aoResult, aoResult == null ? 0 : aoResult.length, null);
    }

    public QueryResult(PartitionSet partitionSet, Object[] aoResult, int cResults) {
        this(partitionSet, aoResult, cResults, null);
    }

    public QueryResult(PartitionSet partitionSet, Object[] aoResult, int cResults, Filter<?> filterRemaining) {
        this.m_partitionSet = partitionSet;
        this.m_aoResult = aoResult;
        this.m_cResults = cResults;
        this.m_filterRemaining = filterRemaining;
        this.m_fOptimized = filterRemaining == null;
    }

    public QueryResult(QueryResult[] aPartResults) {
        PartitionSet parts = null;
        int cResults = 0;
        boolean fOptimized = true;
        for (QueryResult result : aPartResults) {
            cResults += result.getCount();
            if (parts == null) {
                parts = new PartitionSet(result.getPartitionSet());
            } else {
                parts.add(result.getPartitionSet());
            }
            fOptimized = fOptimized && result.m_fOptimized;
        }
        this.m_partitionSet = parts;
        this.m_aPartResult = aPartResults;
        this.m_cResults = cResults;
        this.m_fOptimized = fOptimized;
        this.m_filterRemaining = null;
    }

    public PartitionSet getPartitionSet() {
        return this.m_partitionSet;
    }

    public Object[] getResults() {
        if (this.m_aoResult == null && this.m_aPartResult != null) {
            this.m_aoResult = QueryResult.mergePartialResults(this.m_aPartResult, this.m_cResults);
        }
        return this.m_aoResult;
    }

    public void setResults(Object[] aoResult) {
        this.setResults(aoResult, aoResult.length);
    }

    public void setResults(Object[] aoResult, int cResults) {
        this.m_aoResult = aoResult;
        this.m_cResults = cResults;
        this.m_cbSize = -1L;
    }

    public int getCount() {
        return this.m_cResults;
    }

    public Filter<?> getFilterRemaining() {
        return this.m_filterRemaining;
    }

    public boolean isOptimized() {
        return this.m_fOptimized;
    }

    public int getScannedCount() {
        int cScanned = 0;
        if (this.m_aPartResult != null) {
            for (QueryResult r : this.m_aPartResult) {
                Object[] aoResult = r.m_aoResult;
                if (aoResult == null) continue;
                cScanned += aoResult.length;
            }
        } else if (this.m_aoResult != null) {
            cScanned = this.m_aoResult.length;
        }
        return cScanned;
    }

    public long getSize() {
        long cbSize = this.m_cbSize;
        if (cbSize == -1L) {
            int cResults = this.m_cResults;
            for (int i = 0; i < cResults; ++i) {
                Object o = this.m_aoResult[i];
                if (o instanceof BinaryEntry) {
                    BinaryEntry binEntry = (BinaryEntry)o;
                    cbSize += (long)(binEntry.getBinaryKey().length() + binEntry.getBinaryValue().length());
                    continue;
                }
                if (!(o instanceof Binary)) continue;
                Binary binKey = (Binary)o;
                cbSize += (long)binKey.length();
            }
            this.m_cbSize = cbSize;
        }
        return cbSize;
    }

    public QueryResult[] split(MemorySize maxSize) {
        if (this.m_aPartResult == null || this.m_aPartResult.length == 0) {
            return new QueryResult[]{this};
        }
        ArrayList<QueryResult> lstResults = new ArrayList<QueryResult>();
        PartitionSet parts = null;
        int cResults = 0;
        long cbSize = 0L;
        long cbMaxSize = maxSize.getByteCount();
        ArrayList<QueryResult> lstBatch = new ArrayList<QueryResult>();
        for (QueryResult result : this.m_aPartResult) {
            if (result.getSize() > cbMaxSize) {
                lstResults.add(result);
                continue;
            }
            lstBatch.add(result);
            cResults += result.getCount();
            cbSize += result.getSize();
            if (parts == null) {
                parts = new PartitionSet(result.getPartitionSet());
            } else {
                parts.add(result.getPartitionSet());
            }
            if (cbSize < cbMaxSize) continue;
            Object[] aoResult = QueryResult.mergePartialResults((QueryResult[])lstBatch.toArray(QueryResult[]::new), cResults);
            lstResults.add(new QueryResult(parts, aoResult));
            parts = null;
            cResults = 0;
            cbSize = 0L;
            lstBatch.clear();
        }
        if (!lstBatch.isEmpty()) {
            Object[] aoResult = QueryResult.mergePartialResults((QueryResult[])lstBatch.toArray(QueryResult[]::new), cResults);
            lstResults.add(new QueryResult(parts, aoResult));
        }
        return (QueryResult[])lstResults.toArray(QueryResult[]::new);
    }

    private static Object[] mergePartialResults(QueryResult[] aPartResult, int cResults) {
        Object[] aoResult = new Object[cResults];
        if (cResults > 0) {
            int nPos = 0;
            for (QueryResult resultPart : aPartResult) {
                int cPartResults = resultPart.getCount();
                if (cPartResults <= 0) continue;
                System.arraycopy(resultPart.getResults(), 0, aoResult, nPos, cPartResults);
                nPos += cPartResults;
            }
        }
        return aoResult;
    }
}

