/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.oracle.coherence.common.collections.NullableConcurrentMap;
import com.oracle.coherence.common.collections.NullableSortedMap;
import com.tangosol.internal.util.PartitionedIndexMap;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.ChainedSet;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class PartitionedIndexMap<K, V>
extends AbstractKeyBasedMap<ValueExtractor<V, ?>, MapIndex<K, V, ?>> {
    protected final BackingMapContext f_ctx;
    protected final Map<Integer, Map<ValueExtractor<V, ?>, MapIndex<K, V, ?>>> f_mapPartitioned;
    protected final PartitionSet f_partitions;

    public PartitionedIndexMap(BackingMapContext ctx, Map<Integer, Map<ValueExtractor<V, ?>, MapIndex<K, V, ?>>> mapPartitioned, PartitionSet partitions) {
        this.f_ctx = ctx;
        this.f_mapPartitioned = mapPartitioned;
        this.f_partitions = partitions;
    }

    public <E> MapIndex<K, V, E> get(ValueExtractor<V, E> extractor) {
        int nPart = this.f_partitions == null ? this.f_mapPartitioned.keySet().stream().findFirst().orElse(-1).intValue() : this.f_partitions.rnd();
        MapIndex<K, V, E> mapIndex = this.getMapIndex(nPart, extractor);
        if (mapIndex != null) {
            return this.f_partitions != null && this.f_partitions.cardinality() == 1 ? mapIndex : new PartitionedIndex<E>(extractor, mapIndex.isOrdered(), mapIndex.getComparator());
        }
        return null;
    }

    public Iterable<Integer> getPartitions() {
        return this.f_partitions == null ? this.f_mapPartitioned.keySet() : this.f_partitions;
    }

    protected <E> MapIndex<K, V, E> getMapIndex(int nPart, ValueExtractor<V, E> extractor) {
        Map<ValueExtractor<V, ?>, MapIndex<K, V, ?>> mapPart;
        if (nPart >= 0 && (this.f_partitions == null ? this.f_mapPartitioned.containsKey(nPart) : this.f_partitions.contains(nPart)) && (mapPart = this.f_mapPartitioned.get(nPart)) != null) {
            return mapPart.get(extractor);
        }
        return null;
    }

    @Override
    public MapIndex<K, V, ?> get(Object oKey) {
        return this.get((ValueExtractor)oKey);
    }

    @Override
    protected Iterator<ValueExtractor<V, ?>> iterateKeys() {
        return this.f_mapPartitioned.values().stream().flatMap(map -> map.keySet().stream()).distinct().iterator();
    }

    @Override
    public String toString() {
        return "PartitionedIndexMap{f_ctx=" + String.valueOf(this.f_ctx) + ", f_mapPartitioned=" + String.valueOf(this.f_mapPartitioned) + ", f_partitions=" + String.valueOf(this.f_partitions) + "}";
    }

    public class PartitionedIndex<E>
    implements MapIndex<K, V, E> {
        private final ValueExtractor<V, E> f_extractor;
        private final boolean f_fOrdered;
        private final Comparator<E> f_comparator;

        PartitionedIndex(ValueExtractor<V, E> extractor, boolean fOrdered, Comparator<E> comparator) {
            this.f_extractor = extractor;
            this.f_fOrdered = fOrdered;
            this.f_comparator = fOrdered ? PartitionedIndex.ensureSafeComparator(comparator) : null;
        }

        private static <T> Comparator<T> ensureSafeComparator(Comparator<T> comparator) {
            return comparator == null ? SafeComparator.INSTANCE() : (comparator instanceof SafeComparator ? comparator : new SafeComparator<T>(comparator));
        }

        @Override
        public ValueExtractor<V, E> getValueExtractor() {
            return this.f_extractor;
        }

        @Override
        public boolean isOrdered() {
            return this.f_fOrdered;
        }

        @Override
        public boolean isPartial() {
            for (Map mapPart : PartitionedIndexMap.this.f_mapPartitioned.values()) {
                MapIndex mapIndex = mapPart.get(this.f_extractor);
                if (mapIndex == null || !mapIndex.isPartial()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<E, Set<K>> getIndexContents() {
            return this.isOrdered() ? new SortedIndexContents() : new IndexContents();
        }

        @Override
        public Object get(K key) {
            int nPart = PartitionedIndexMap.this.f_ctx.getManagerContext().getKeyPartition(key);
            MapIndex mapIndex = PartitionedIndexMap.this.getMapIndex(nPart, this.f_extractor);
            return mapIndex == null ? NO_VALUE : mapIndex.get(key);
        }

        @Override
        public Comparator<E> getComparator() {
            return this.f_comparator;
        }

        @Override
        public void insert(Map.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException("PartitionedIndex is read-only");
        }

        @Override
        public void update(Map.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException("PartitionedIndex is read-only");
        }

        @Override
        public void delete(Map.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException("PartitionedIndex is read-only");
        }

        @Override
        public long getUnits() {
            long cUnits = 0L;
            for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                MapIndex mapIndex = PartitionedIndexMap.this.getMapIndex(nPart, this.f_extractor);
                cUnits += mapIndex != null ? mapIndex.getUnits() : 0L;
            }
            return cUnits;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean fVerbose) {
            return ClassHelper.getSimpleName(this.getClass()) + ": Extractor=" + String.valueOf(this.getValueExtractor()) + ", Ordered=" + this.isOrdered() + ", Footprint=" + Base.toMemorySizeString(this.getUnits(), false) + (String)(fVerbose ? ", Content[" + this.getIndexContents().size() + "]=" + String.valueOf(this.getIndexContents().keySet()) : "");
        }

        class SortedIndexContents
        extends IndexContents
        implements NavigableMap<E, Set<K>> {
            SortedIndexContents() {
            }

            @Override
            public Map.Entry<E, Set<K>> lowerEntry(E key) {
                return this.instantiateEntry(this.lowerKey((E)key));
            }

            @Override
            public E lowerKey(E key) {
                Object lowerKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Object partKey = this.getIndexContents(nPart).lowerKey(key);
                    if (partKey == null || lowerKey != null && PartitionedIndex.this.f_comparator.compare(partKey, lowerKey) <= 0) continue;
                    lowerKey = partKey;
                }
                return lowerKey;
            }

            @Override
            public Map.Entry<E, Set<K>> floorEntry(E key) {
                return this.instantiateEntry(this.floorKey((E)key));
            }

            @Override
            public E floorKey(E key) {
                Object floorKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Object partKey = this.getIndexContents(nPart).floorKey(key);
                    if (partKey == null || floorKey != null && PartitionedIndex.this.f_comparator.compare(partKey, floorKey) <= 0) continue;
                    floorKey = partKey;
                }
                return floorKey;
            }

            @Override
            public Map.Entry<E, Set<K>> ceilingEntry(E key) {
                return this.instantiateEntry(this.ceilingKey((E)key));
            }

            @Override
            public E ceilingKey(E key) {
                Object ceilingKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Object partKey = this.getIndexContents(nPart).ceilingKey(key);
                    if (partKey == null || ceilingKey != null && PartitionedIndex.this.f_comparator.compare(partKey, ceilingKey) >= 0) continue;
                    ceilingKey = partKey;
                }
                return ceilingKey;
            }

            @Override
            public Map.Entry<E, Set<K>> higherEntry(E key) {
                return this.instantiateEntry(this.higherKey((E)key));
            }

            @Override
            public E higherKey(E key) {
                Object higherKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Object partKey = this.getIndexContents(nPart).higherKey(key);
                    if (partKey == null || higherKey != null && PartitionedIndex.this.f_comparator.compare(partKey, higherKey) >= 0) continue;
                    higherKey = partKey;
                }
                return higherKey;
            }

            @Override
            public Map.Entry<E, Set<K>> firstEntry() {
                Object firstKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Optional<Object> partKey = Optional.ofNullable(this.getIndexContents(nPart).firstEntry()).map(Map.Entry::getKey);
                    if (!partKey.isPresent() || firstKey != null && PartitionedIndex.this.f_comparator.compare(partKey.get(), firstKey) >= 0) continue;
                    firstKey = partKey.get();
                }
                return this.instantiateEntry(firstKey);
            }

            @Override
            public Map.Entry<E, Set<K>> lastEntry() {
                Object lastKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Optional<Object> partKey = Optional.ofNullable(this.getIndexContents(nPart).lastEntry()).map(Map.Entry::getKey);
                    if (!partKey.isPresent() || lastKey != null && PartitionedIndex.this.f_comparator.compare(partKey.get(), lastKey) <= 0) continue;
                    lastKey = partKey.get();
                }
                return this.instantiateEntry(lastKey);
            }

            @Override
            public Map.Entry<E, Set<K>> pollFirstEntry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map.Entry<E, Set<K>> pollLastEntry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public NavigableMap<E, Set<K>> descendingMap() {
                throw new UnsupportedOperationException();
            }

            @Override
            public NavigableSet<E> navigableKeySet() {
                return (NavigableSet)this.keySet();
            }

            @Override
            public NavigableSet<E> descendingKeySet() {
                return this.navigableKeySet().descendingSet();
            }

            @Override
            public NavigableMap<E, Set<K>> subMap(E fromKey, boolean fFromInclusive, E toKey, boolean fToInclusive) {
                NullableSortedMap mapSorted = new NullableSortedMap(PartitionedIndex.this.f_comparator);
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    NavigableMap subMap = this.getIndexContents(nPart).subMap(fromKey, fFromInclusive, toKey, fToInclusive);
                    subMap.forEach((k, v) -> mapSorted.merge(k, v, (v1, v2) -> this.chainSets((Set)v1, (Set)v2)));
                }
                return mapSorted;
            }

            @Override
            public NavigableMap<E, Set<K>> headMap(E toKey, boolean fInclusive) {
                NullableSortedMap mapSorted = new NullableSortedMap(PartitionedIndex.this.f_comparator);
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    NavigableMap headMap = this.getIndexContents(nPart).headMap(toKey, fInclusive);
                    headMap.forEach((k, v) -> mapSorted.merge(k, v, (v1, v2) -> this.chainSets((Set)v1, (Set)v2)));
                }
                return mapSorted;
            }

            @Override
            public NavigableMap<E, Set<K>> tailMap(E fromKey, boolean fInclusive) {
                NullableSortedMap mapSorted = new NullableSortedMap(PartitionedIndex.this.f_comparator);
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    NavigableMap tailMap = this.getIndexContents(nPart).tailMap(fromKey, fInclusive);
                    tailMap.forEach((k, v) -> mapSorted.merge(k, v, (v1, v2) -> this.chainSets((Set)v1, (Set)v2)));
                }
                return mapSorted;
            }

            @Override
            public Comparator<? super E> comparator() {
                return PartitionedIndex.this.f_comparator;
            }

            @Override
            public SortedMap<E, Set<K>> subMap(E fromKey, E toKey) {
                return this.subMap((E)fromKey, true, (E)toKey, false);
            }

            @Override
            public SortedMap<E, Set<K>> headMap(E toKey) {
                return this.headMap((E)toKey, false);
            }

            @Override
            public SortedMap<E, Set<K>> tailMap(E fromKey) {
                return this.tailMap((E)fromKey, true);
            }

            @Override
            public SortedSet<E> keySet() {
                return (SortedSet)super.keySet();
            }

            @Override
            public E firstKey() {
                Object firstKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Optional<Object> partKey = Optional.ofNullable(this.getIndexContents(nPart).firstEntry()).map(Map.Entry::getKey);
                    if (!partKey.isPresent() || firstKey != null && PartitionedIndex.this.f_comparator.compare(partKey.get(), firstKey) >= 0) continue;
                    firstKey = partKey.get();
                }
                if (firstKey == null) {
                    throw new NoSuchElementException();
                }
                return firstKey;
            }

            @Override
            public E lastKey() {
                Object lastKey = null;
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Optional<Object> partKey = Optional.ofNullable(this.getIndexContents(nPart).lastEntry()).map(Map.Entry::getKey);
                    if (!partKey.isPresent() || lastKey != null && PartitionedIndex.this.f_comparator.compare(partKey.get(), lastKey) <= 0) continue;
                    lastKey = partKey.get();
                }
                if (lastKey == null) {
                    throw new NoSuchElementException();
                }
                return lastKey;
            }

            @Override
            protected Map<E, Set<K>> emptyMap() {
                return NullableSortedMap.EMPTY;
            }

            protected SortedSet<E> instantiateKeySet() {
                return new TreeSet(PartitionedIndex.this.f_comparator);
            }

            protected NavigableMap<E, Set<K>> getIndexContents(int nPart) {
                return (NavigableMap)super.getIndexContents(nPart);
            }

            private Set<K> chainSets(Set<K> setFirst, Set<K> setSecond) {
                return setFirst instanceof ChainedSet ? new ChainedSet((ChainedSet)setFirst, setSecond) : new ChainedSet(setFirst, setSecond);
            }
        }

        private class IndexContents
        implements Map<E, Set<K>> {
            private IndexContents() {
            }

            @Override
            public int size() {
                return this.keySet().size();
            }

            @Override
            public boolean isEmpty() {
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    if (this.getIndexContents(nPart).isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean containsKey(Object oKey) {
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    if (!this.getIndexContents(nPart).containsKey(oKey)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsValue(Object oValue) {
                return this.values().contains(oValue);
            }

            @Override
            public Set<K> get(Object oKey) {
                int cCapacity = PartitionedIndexMap.this.f_partitions == null ? PartitionedIndexMap.this.f_mapPartitioned.size() : PartitionedIndexMap.this.f_partitions.cardinality();
                ArrayList listKeySets = new ArrayList(cCapacity);
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    Set setKeys = this.getIndexContents(nPart).get(oKey);
                    if (setKeys == null || setKeys.isEmpty()) continue;
                    listKeySets.add(setKeys);
                }
                return new ChainedSet(listKeySets);
            }

            @Override
            public Set<K> put(E key, Set<K> value) {
                throw new UnsupportedOperationException("PartitionedIndex is read-only");
            }

            @Override
            public Set<K> remove(Object key) {
                throw new UnsupportedOperationException("PartitionedIndex is read-only");
            }

            @Override
            public void putAll(Map<? extends E, ? extends Set<K>> m) {
                throw new UnsupportedOperationException("PartitionedIndex is read-only");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("PartitionedIndex is read-only");
            }

            @Override
            public Set<E> keySet() {
                Set setKeys = this.instantiateKeySet();
                for (int nPart : PartitionedIndexMap.this.getPartitions()) {
                    setKeys.addAll(this.getIndexContents(nPart).keySet());
                }
                return setKeys;
            }

            @Override
            public Collection<Set<K>> values() {
                final Set setKeys = this.keySet();
                return new AbstractCollection<Set<K>>(){

                    @Override
                    public Iterator<Set<K>> iterator() {
                        final Iterator itKeys = setKeys.iterator();
                        return new Iterator<Set<K>>(){

                            @Override
                            public boolean hasNext() {
                                return itKeys.hasNext();
                            }

                            @Override
                            public Set<K> next() {
                                return IndexContents.this.get(itKeys.next());
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return setKeys.size();
                    }
                };
            }

            @Override
            public Set<Map.Entry<E, Set<K>>> entrySet() {
                final Set setKeys = this.keySet();
                return new AbstractSet<Map.Entry<E, Set<K>>>(){

                    @Override
                    public Iterator<Map.Entry<E, Set<K>>> iterator() {
                        final Iterator itKeys = setKeys.iterator();
                        return new Iterator<Map.Entry<E, Set<K>>>(){

                            @Override
                            public boolean hasNext() {
                                return itKeys.hasNext();
                            }

                            @Override
                            public Map.Entry<E, Set<K>> next() {
                                return new Entry(itKeys.next());
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return setKeys.size();
                    }
                };
            }

            protected Map<E, Set<K>> emptyMap() {
                return NullableConcurrentMap.EMPTY;
            }

            protected Set<E> instantiateKeySet() {
                return new HashSet();
            }

            protected com.tangosol.internal.util.PartitionedIndexMap$PartitionedIndex$IndexContents.Entry instantiateEntry(E key) {
                return new Entry(key);
            }

            protected Map<E, Set<K>> getIndexContents(int nPart) {
                MapIndex mapIndex = PartitionedIndexMap.this.getMapIndex(nPart, PartitionedIndex.this.f_extractor);
                return mapIndex != null ? mapIndex.getIndexContents() : this.emptyMap();
            }

            class Entry
            implements Map.Entry<E, Set<K>> {
                private final E f_key;

                Entry(E key) {
                    this.f_key = key;
                }

                @Override
                public E getKey() {
                    return this.f_key;
                }

                @Override
                public Set<K> getValue() {
                    return IndexContents.this.get(this.f_key);
                }

                @Override
                public Set<K> setValue(Set<K> value) {
                    throw new UnsupportedOperationException("PartitionedIndex is read-only");
                }
            }
        }
    }
}

