/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class OrderedView<K, V>
implements NamedCache<K, V>,
MapListener<K, V> {
    private final NamedCache<K, V> f_source;
    private final Comparator<? super V> f_comparator;
    private final SortedSet<Map.Entry<K, V>> f_sortedView;

    public OrderedView(NamedCache<K, V> source, Comparator<? super V> comparator) {
        this.f_source = source;
        this.f_comparator = SafeComparator.ensureSafe(comparator);
        this.f_sortedView = new ConcurrentSkipListSet<Map.Entry<K, V>>(new EntryComparator());
        source.addMapListener(this);
        this.f_sortedView.addAll(source.entrySet());
    }

    public NamedCache<K, V> getSource() {
        return this.f_source;
    }

    public Comparator<? super V> getComparator() {
        return this.f_comparator;
    }

    private Predicate<? super Map.Entry<K, V>> toPredicate(Filter<?> filter) {
        return entry -> InvocableMapHelper.evaluateEntry(filter, entry);
    }

    @Override
    public String getCacheName() {
        return this.f_source.getCacheName();
    }

    @Override
    public CacheService getCacheService() {
        return this.f_source.getCacheService();
    }

    @Override
    public V put(K key, V value, long ttl) {
        return this.f_source.put(key, value, ttl);
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> colKeys) {
        return this.f_source.getAll(colKeys);
    }

    @Override
    public boolean isActive() {
        return this.f_source.isActive();
    }

    @Override
    public void destroy() {
        this.f_source.destroy();
    }

    @Override
    public void release() {
        this.f_source.release();
    }

    @Override
    public boolean lock(Object oKey, long cMillis) {
        return this.f_source.lock(oKey, cMillis);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.f_source.lock(oKey);
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.f_source.unlock(oKey);
    }

    @Override
    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        return this.f_source.invoke(key, entryProcessor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        return this.f_source.invokeAll(colKeys, entryProcessor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        return this.f_source.invokeAll(filter, entryProcessor);
    }

    @Override
    public <R> R aggregate(Collection<? extends K> colKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.f_source.aggregate(colKeys, entryAggregator);
    }

    @Override
    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.f_source.aggregate(filter, entryAggregator);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_source.addMapListener(mapListener);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_source.removeMapListener(mapListener);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> mapListener, K key, boolean fLite) {
        this.f_source.addMapListener(mapListener, (K)key, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> mapListener, K key) {
        this.f_source.removeMapListener(mapListener, (K)key);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> mapListener, Filter filter, boolean fLite) {
        this.f_source.addMapListener(mapListener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> mapListener, Filter filter) {
        this.f_source.removeMapListener(mapListener, filter);
    }

    @Override
    public Set<K> keySet(Filter filter) {
        return this.f_sortedView.stream().filter(this.toPredicate(filter)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        return this.f_sortedView.stream().filter(this.toPredicate(filter)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        TreeSet<Map.Entry<K, V>> set = new TreeSet<Map.Entry<K, V>>(comparator);
        set.addAll(this.entrySet(filter));
        return set;
    }

    @Override
    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        this.f_source.addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
        this.f_source.removeIndex(extractor);
    }

    @Override
    public int size() {
        return this.f_source.size();
    }

    @Override
    public boolean isEmpty() {
        return this.f_source.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.f_source.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.f_source.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.f_source.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.f_source.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.f_source.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.f_source.putAll(map);
    }

    @Override
    public void clear() {
        this.f_sortedView.clear();
        this.f_source.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.f_sortedView.stream().map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Collection<V> values() {
        return this.f_sortedView.stream().map(Map.Entry::getValue).toList();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.f_sortedView;
    }

    @Override
    public void entryInserted(MapEvent<K, V> evt) {
        this.f_sortedView.add(evt.getNewEntry());
    }

    @Override
    public void entryUpdated(MapEvent<K, V> evt) {
        this.entryDeleted(evt);
        this.entryInserted(evt);
    }

    @Override
    public void entryDeleted(MapEvent<K, V> evt) {
        this.f_sortedView.remove(evt.getOldEntry());
    }

    private class EntryComparator
    implements Comparator<Map.Entry<? extends K, ? extends V>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<? extends K, ? extends V> e1, Map.Entry<? extends K, ? extends V> e2) {
            int nComp = OrderedView.this.f_comparator.compare(e1.getValue(), e2.getValue());
            return nComp == 0 ? 1 : nComp;
        }
    }
}

