/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.function.Remote;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class LongSummaryStatistics
extends java.util.LongSummaryStatistics
implements Remote.LongConsumer,
Remote.IntConsumer,
SerializationSupport,
ExternalizableLite,
PortableObject,
Externalizable {
    private static final long serialVersionUID = 6685745411569023906L;
    @JsonbTransient
    private transient long m_cCount;
    @JsonbTransient
    private transient long m_lSum;
    @JsonbTransient
    private transient long m_lMin = Long.MAX_VALUE;
    @JsonbTransient
    private transient long m_lMax = Long.MIN_VALUE;

    public LongSummaryStatistics() {
    }

    public LongSummaryStatistics(long count, long min, long max, long sum) {
        super(count, min, max, sum);
        this.m_cCount = count;
        this.m_lMin = min;
        this.m_lMax = max;
        this.m_lSum = sum;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return new LongSummaryStatistics(this.m_cCount, this.m_lMin, this.m_lMax, this.m_lSum);
    }

    @Override
    public void readExternal(DataInput input) throws IOException {
        this.m_cCount = input.readLong();
        this.m_lSum = input.readLong();
        this.m_lMin = input.readLong();
        this.m_lMax = input.readLong();
    }

    @Override
    public void writeExternal(DataOutput output) throws IOException {
        output.writeLong(this.getCount());
        output.writeLong(this.getSum());
        output.writeLong(this.getMin());
        output.writeLong(this.getMax());
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_cCount = reader.readLong(0);
        this.m_lSum = reader.readLong(1);
        this.m_lMin = reader.readLong(2);
        this.m_lMax = reader.readLong(3);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.getCount());
        writer.writeLong(1, this.getSum());
        writer.writeLong(2, this.getMin());
        writer.writeLong(3, this.getMax());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @JsonbCreator
    public static LongSummaryStatistics createLongSummaryStatistics(@JsonbProperty(value="count") long count, @JsonbProperty(value="sum") long sum, @JsonbProperty(value="min") long min, @JsonbProperty(value="max") long max) throws NoSuchFieldException, IllegalAccessException {
        return new LongSummaryStatistics(count, min, max, sum);
    }

    @JsonbProperty(value="count")
    private long getCountProperty() {
        return this.getCount();
    }

    @JsonbProperty(value="sum")
    private long getSumProperty() {
        return this.getSum();
    }

    @JsonbProperty(value="min")
    private long getMinProperty() {
        return this.getMin();
    }

    @JsonbProperty(value="max")
    private long getMaxProperty() {
        return this.getMax();
    }
}

