/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.function.Remote;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class IntSummaryStatistics
extends java.util.IntSummaryStatistics
implements Remote.IntConsumer,
SerializationSupport,
ExternalizableLite,
PortableObject,
Externalizable {
    private static final long serialVersionUID = -9125140016494900282L;
    @JsonbTransient
    private transient long m_cCount;
    @JsonbTransient
    private transient long m_lSum;
    @JsonbTransient
    private transient int m_nMin = Integer.MAX_VALUE;
    @JsonbTransient
    private transient int m_nMax = Integer.MIN_VALUE;

    public IntSummaryStatistics() {
    }

    public IntSummaryStatistics(long count, int min, int max, long sum) {
        super(count, min, max, sum);
        this.m_cCount = count;
        this.m_nMin = min;
        this.m_nMax = max;
        this.m_lSum = sum;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return new IntSummaryStatistics(this.m_cCount, this.m_nMin, this.m_nMax, this.m_lSum);
    }

    @Override
    public void readExternal(DataInput input) throws IOException {
        this.m_cCount = input.readLong();
        this.m_lSum = input.readLong();
        this.m_nMin = input.readInt();
        this.m_nMax = input.readInt();
    }

    @Override
    public void writeExternal(DataOutput output) throws IOException {
        output.writeLong(this.getCount());
        output.writeLong(this.getSum());
        output.writeInt(this.getMin());
        output.writeInt(this.getMax());
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.getCount());
        writer.writeLong(1, this.getSum());
        writer.writeInt(2, this.getMin());
        writer.writeInt(3, this.getMax());
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_cCount = reader.readLong(0);
        this.m_lSum = reader.readLong(1);
        this.m_nMin = reader.readInt(2);
        this.m_nMax = reader.readInt(3);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @JsonbCreator
    public static IntSummaryStatistics createIntSummaryStatistics(@JsonbProperty(value="count") long count, @JsonbProperty(value="sum") long sum, @JsonbProperty(value="min") int min, @JsonbProperty(value="max") int max) throws NoSuchFieldException, IllegalAccessException {
        return new IntSummaryStatistics(count, min, max, sum);
    }

    @JsonbProperty(value="count")
    private long getCountProperty() {
        return this.getCount();
    }

    @JsonbProperty(value="sum")
    private long getSumProperty() {
        return this.getSum();
    }

    @JsonbProperty(value="min")
    private int getMinProperty() {
        return this.getMin();
    }

    @JsonbProperty(value="max")
    private int getMaxProperty() {
        return this.getMax();
    }
}

