/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.IntConsumer;

public class IntBag
implements ExternalizableLite,
PortableObject {
    protected static final int[] EMPTY_ARRAY = new int[0];
    @JsonbProperty(value="array")
    protected int[] m_a;
    @JsonbProperty(value="size")
    protected int m_c;

    public IntBag() {
        this.m_a = EMPTY_ARRAY;
    }

    public IntBag(int nInitialCapacity) {
        this.m_a = new int[nInitialCapacity];
    }

    public void add(int l) {
        int i = this.m_c++;
        this.ensureStorage((int)(i + 1))[i] = l;
    }

    public void addAll(IntBag that) {
        int[] aThat = that.m_a;
        int cThat = that.m_c;
        this.ensureStorage(this.m_c + cThat);
        for (int i = 0; i < cThat; ++i) {
            this.add(aThat[i]);
        }
    }

    public void forEach(IntConsumer consumer) {
        int[] a = this.m_a;
        int c = this.m_c;
        for (int i = 0; i < c; ++i) {
            consumer.accept(a[i]);
        }
    }

    public int size() {
        return this.m_c;
    }

    public int[] toArray() {
        int[] a = this.m_a;
        int c = this.m_c;
        int[] aCopy = new int[c];
        System.arraycopy(a, 0, aCopy, 0, c);
        return aCopy;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_a = ExternalizableHelper.readIntArray(in);
        this.m_c = this.m_a.length;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int[] a = this.m_a;
        int c = this.m_c;
        out.writeInt(c);
        for (int i = 0; i < c; ++i) {
            out.writeInt(a[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int[] a = in.readIntArray(0);
        this.m_a = a;
        this.m_c = a.length;
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeIntArray(0, this.toArray());
    }

    public int hashCode() {
        int[] a = this.m_a;
        int n = 31;
        int c = this.m_c;
        for (int i = 0; i < c; ++i) {
            n = HashHelper.hash(a[i], n);
        }
        return n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach(n -> sb.append(sb.length() == 0 ? "" : ", ").append(n));
        return "[" + String.valueOf(sb) + "]";
    }

    public boolean equals(Object oThat) {
        if (oThat == this) {
            return true;
        }
        if (!(oThat instanceof IntBag)) {
            return false;
        }
        IntBag that = (IntBag)oThat;
        int[] aThat = that.m_a;
        int cThat = that.m_c;
        int[] a = this.m_a;
        int c = this.m_c;
        if (c != cThat) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (a[i] == aThat[i]) continue;
            return false;
        }
        return true;
    }

    protected int[] ensureStorage(int c) {
        int[] a = this.m_a;
        if (a.length < c) {
            int[] aNew = new int[c * 2];
            System.arraycopy(a, 0, aNew, 0, a.length);
            a = aNew;
            this.m_a = aNew;
        }
        return a;
    }
}

