/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.function.Remote;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class DoubleSummaryStatistics
extends java.util.DoubleSummaryStatistics
implements Remote.DoubleConsumer,
SerializationSupport,
ExternalizableLite,
PortableObject,
Externalizable {
    private static final long serialVersionUID = -697250990486066143L;
    @JsonbTransient
    private transient long m_cCount;
    @JsonbTransient
    private transient double m_dMin = Double.POSITIVE_INFINITY;
    @JsonbTransient
    private transient double m_dMax = Double.NEGATIVE_INFINITY;
    @JsonbTransient
    private transient double m_dSum;

    public DoubleSummaryStatistics() {
    }

    public DoubleSummaryStatistics(long count, double min, double max, double sum) {
        super(count, min, max, sum);
        this.m_cCount = count;
        this.m_dMin = min;
        this.m_dMax = max;
        this.m_dSum = sum;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return new DoubleSummaryStatistics(this.m_cCount, this.m_dMin, this.m_dMax, this.m_dSum);
    }

    @Override
    public void readExternal(DataInput input) throws IOException {
        this.m_cCount = input.readLong();
        this.m_dSum = input.readDouble();
        input.readDouble();
        input.readDouble();
        this.m_dMin = input.readDouble();
        this.m_dMax = input.readDouble();
    }

    @Override
    public void writeExternal(DataOutput output) throws IOException {
        output.writeLong(this.getCount());
        output.writeDouble(this.getSum());
        output.writeDouble(0.0);
        output.writeDouble(this.getSum());
        output.writeDouble(this.getMin());
        output.writeDouble(this.getMax());
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_cCount = reader.readLong(0);
        this.m_dSum = reader.readDouble(1);
        reader.readDouble(2);
        reader.readDouble(3);
        this.m_dMin = reader.readDouble(4);
        this.m_dMax = reader.readDouble(5);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.getCount());
        writer.writeDouble(1, this.getSum());
        writer.writeDouble(2, 0.0);
        writer.writeDouble(3, this.getSum());
        writer.writeDouble(4, this.getMin());
        writer.writeDouble(5, this.getMax());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @JsonbCreator
    public static DoubleSummaryStatistics createDoubleSummaryStatistics(@JsonbProperty(value="count") long count, @JsonbProperty(value="min") double min, @JsonbProperty(value="max") double max, @JsonbProperty(value="sum") double sum) {
        return new DoubleSummaryStatistics(count, min, max, sum);
    }

    @JsonbProperty(value="count")
    private long getCountProperty() {
        return this.getCount();
    }

    @JsonbProperty(value="min")
    private double getMinProperty() {
        return this.getMin();
    }

    @JsonbProperty(value="max")
    private double getMaxProperty() {
        return this.getMax();
    }

    @JsonbProperty(value="sum")
    private double getSumProperty() {
        return this.getSum();
    }
}

