/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.internal.util.DefaultAsyncNamedCache;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.internal.util.processor.BinaryProcessors;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

public class DistributedAsyncNamedCache<K, V>
extends DefaultAsyncNamedCache<K, V> {
    public static final IntPredicate IS_BINARY_PROCESSOR_COMPATIBLE = DistributedAsyncNamedCache::isBinaryProcessorCompatible;
    private final Converter<Binary, K> f_keyFromInternalConverter;
    private final Converter<K, Binary> f_keyToInternalConverter;
    private final Converter<Binary, V> f_valueFromInternalConverter;
    private final Converter<V, Binary> f_valueToInternalConverter;

    public DistributedAsyncNamedCache(NamedCache<K, V> cache) {
        this(cache, null);
    }

    public DistributedAsyncNamedCache(NamedCache<K, V> cache, AsyncNamedMap.Option[] options) {
        super(cache, options);
        CacheService service = cache.getCacheService();
        BackingMapManagerContext context = service.getBackingMapManager().getContext();
        this.f_keyFromInternalConverter = context.getKeyFromInternalConverter();
        this.f_keyToInternalConverter = context.getKeyToInternalConverter();
        this.f_valueFromInternalConverter = context.getValueFromInternalConverter();
        this.f_valueToInternalConverter = context.getValueToInternalConverter();
    }

    @Override
    public CompletableFuture<V> get(K key) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        CompletableFuture<Binary> future = this.invoke(key, processor);
        return future.thenApply(this.f_valueFromInternalConverter::convert);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Collection<? extends K> colKeys) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invokeAll(colKeys, processor);
    }

    @Override
    public CompletableFuture<Void> getAll(Collection<? extends K> colKeys, BiConsumer<? super K, ? super V> callback) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invokeAll(colKeys, processor, (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    @Override
    public CompletableFuture<Void> getAll(Collection<? extends K> colKeys, Consumer<? super Map.Entry<? extends K, ? extends V>> callback) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invokeAll(colKeys, processor, callback);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Filter<?> filter) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        CompletableFuture<Map<Binary, Binary>> future = this.invokeAll(filter, processor);
        return future.thenApply(mapBinary -> ConverterCollections.getMap(mapBinary, this.f_keyFromInternalConverter, this.f_keyToInternalConverter, this.f_valueFromInternalConverter, this.f_valueToInternalConverter));
    }

    @Override
    public CompletableFuture<Void> getAll(Filter<?> filter, BiConsumer<? super K, ? super V> callback) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invokeAll(filter, processor, (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    @Override
    public CompletableFuture<Void> getAll(Filter<?> filter, Consumer<? super Map.Entry<? extends K, ? extends V>> callback) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invokeAll(filter, processor, callback);
    }

    @Override
    public CompletableFuture<V> getOrDefault(K key, V valueDefault) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.get();
        return this.invoke(key, processor).thenApply(bin -> {
            if (bin != null) {
                return this.f_valueFromInternalConverter.convert((Binary)bin);
            }
            return valueDefault;
        });
    }

    @Override
    public CompletableFuture<Void> put(K key, V value) {
        return this.put(key, value, 0L);
    }

    @Override
    public CompletableFuture<Void> put(K key, V value, long cMillis) {
        Binary binary = (Binary)this.f_valueToInternalConverter.convert(value);
        if (this.isBinaryProcessorCompatible()) {
            InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.blindPut(binary, cMillis);
            return this.invoke(key, processor);
        }
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.put(binary, cMillis);
        return this.invoke(key, processor).thenAccept(ANY);
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map) {
        ConverterCollections.ConverterMap<? extends K, Binary, ? extends V, Binary> mapBinary = ConverterCollections.getMap(map, this.f_keyToInternalConverter, this.f_keyFromInternalConverter, this.f_valueToInternalConverter, this.f_valueFromInternalConverter);
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.putAll(mapBinary);
        return this.invokeAll(map.keySet(), processor).thenAccept(ANY);
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map, long cMillis) {
        if (this.isBinaryProcessorCompatible()) {
            ConverterCollections.ConverterMap<? extends K, Binary, ? extends V, Binary> mapBinary = ConverterCollections.getMap(map, this.f_keyToInternalConverter, this.f_keyFromInternalConverter, this.f_valueToInternalConverter, this.f_valueFromInternalConverter);
            InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.putAll(mapBinary, cMillis);
            return this.invokeAll(map.keySet(), processor).thenAccept(ANY);
        }
        CacheService service = this.getNamedCache().getService();
        int nVersion = service.getMinimumServiceVersion();
        throw new UnsupportedOperationException("the whole cluster is not running a compatible version to execute this method (version=\"" + VersionHelper.toVersionString(nVersion, true) + "\" encoded=" + nVersion + ")");
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        Binary binary = (Binary)this.f_valueToInternalConverter.convert(value);
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.putIfAbsent(binary, 0L);
        return this.invoke(key, processor).thenApply(bin -> bin == null ? null : this.f_valueFromInternalConverter.convert((Binary)bin));
    }

    @Override
    public CompletableFuture<V> remove(K key) {
        InvocableMap.EntryProcessor<Binary, Binary, Binary> processor = BinaryProcessors.remove();
        CompletableFuture<Binary> future = this.invoke(key, processor);
        return future.thenApply(this.f_valueFromInternalConverter::convert);
    }

    @Override
    public CompletableFuture<Void> removeAll(Collection<? extends K> colKeys) {
        if (this.isBinaryProcessorCompatible()) {
            return this.invokeAll(colKeys, CacheProcessors.removeWithoutResults()).thenAccept(ANY);
        }
        return this.invokeAll(colKeys, CacheProcessors.removeBlind()).thenAccept(ANY);
    }

    @Override
    public CompletableFuture<Void> removeAll(Filter<?> filter) {
        if (this.isBinaryProcessorCompatible()) {
            return this.invokeAll(filter, CacheProcessors.removeWithoutResults()).thenAccept(ANY);
        }
        return this.invokeAll(filter, CacheProcessors.removeBlind()).thenAccept(ANY);
    }

    protected boolean isBinaryProcessorCompatible() {
        return this.m_cache.getService().isVersionCompatible(IS_BINARY_PROCESSOR_COMPATIBLE);
    }

    protected static boolean isBinaryProcessorCompatible(int nVersion) {
        return VersionHelper.isVersionCompatible(VersionHelper.VERSION_23_09, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_14_1_2_0, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_14_1_1_2206_6, nVersion);
    }
}

