/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.util.Base;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public abstract class Daemons {
    private static final String DAEMON_POOL = "com.tangosol.coherence.component.util.DaemonPool";
    private static final int FORK_JOIN_POOL_PARALLELISM = Config.getInteger("coherence.forkjoinpool.parallelism", Runtime.getRuntime().availableProcessors());
    private static final Class DAEMON_POOL_CLASS;
    private static final ForkJoinPool FORK_JOIN_POOL;

    public static DaemonPool newDaemonPool(DaemonPoolDependencies deps) {
        try {
            DaemonPool pool = (DaemonPool)DAEMON_POOL_CLASS.newInstance();
            pool.setDependencies(deps);
            return pool;
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static DaemonPool commonPool() {
        return ((OperationalContext)((Object)CacheFactory.getCluster())).getCommonDaemonPool();
    }

    public static ForkJoinPool forkJoinPool() {
        return FORK_JOIN_POOL;
    }

    public static boolean isForkJoinPoolEnabled() {
        return FORK_JOIN_POOL != null;
    }

    static {
        try {
            DAEMON_POOL_CLASS = Class.forName(DAEMON_POOL);
            FORK_JOIN_POOL = FORK_JOIN_POOL_PARALLELISM > 1 ? new ForkJoinPool(FORK_JOIN_POOL_PARALLELISM, ForkJoinPoolWorker::new, null, false) : null;
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    static class ForkJoinPoolWorker
    extends ForkJoinWorkerThread {
        ForkJoinPoolWorker(ForkJoinPool pool) {
            super(pool);
        }
    }
}

