/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentracing;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.tracing.opentracing.AbstractOpenTracingSpanBuilder;
import com.tangosol.internal.tracing.opentracing.OpenTracingSpan;
import com.tangosol.util.Base;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopSpan;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

@Deprecated
public abstract class AbstractOpenTracingShim
implements TracingShim {
    protected TracingShim.Dependencies m_dependencies;
    protected Tracer m_tracer;
    protected static final String JAEGER_SAMPLER_TYPE_PROPERTY = "JAEGER_SAMPLER_TYPE";
    protected static final String JAEGER_SAMPLER_VALUE_PROPERTY = "JAEGER_SAMPLER_PARAM";
    protected static final String JAEGER_DEFAULT_SAMPLER_TYPE = "probabilistic";
    protected static final float TRACING_LOWER_SAMPLE_RANGE = 0.0f;
    protected static final float TRACING_UPPER_SAMPLE_RANGE = 1.0f;
    protected static final OpenTracingSpan NOOP_SPAN = new OpenTracingSpan((io.opentracing.Span)NoopSpan.INSTANCE);
    protected static final AbstractOpenTracingSpanBuilder NOOP_BUILDER = new AbstractOpenTracingSpanBuilder(NoopTracerFactory.create().buildSpan("no-op")){

        @Override
        public Span startSpan() {
            return NOOP_SPAN;
        }
    };

    protected abstract boolean registerTracer(io.opentracing.Tracer var1) throws Exception;

    protected abstract void onControlClose();

    protected abstract String getApiVersion();

    protected abstract Tracer createTracer();

    @Override
    public Span activateSpan(Span span) {
        if (span != null) {
            ((io.opentracing.Tracer)this.m_tracer.underlying()).scopeManager().activate((io.opentracing.Span)span.underlying());
        }
        return span;
    }

    @Override
    public TracingShim.Control initialize(TracingShim.Dependencies dependencies) {
        this.m_dependencies = new TracingShim.DefaultDependencies(dependencies);
        final TracingShim.DefaultDependencies depsFin = this.m_dependencies;
        this.m_tracer = this.createTracer();
        if (this.isEnabled()) {
            return null;
        }
        float flSamplingRatio = dependencies.getSamplingRatio();
        if (AbstractOpenTracingShim.checkTracingEnabled(flSamplingRatio)) {
            AbstractOpenTracingShim.configureTracingSampling(flSamplingRatio);
            io.opentracing.Tracer tracer = TracerResolver.resolveTracer((ClassLoader)Base.getContextClassLoader());
            if (tracer != null) {
                try {
                    if (!this.registerTracer(tracer)) {
                        return null;
                    }
                }
                catch (Exception e) {
                    Logger.finest(() -> "Unexpected exception during Tracer registration:", (Throwable)e);
                    return null;
                }
            }
        }
        final io.opentracing.Tracer tracerFin = GlobalTracer.get();
        Logger.finest(() -> "Initialized TracingShim: " + String.valueOf(this));
        return new TracingShim.Control(){
            protected boolean m_fClosed;

            @Override
            public synchronized void close() {
                if (!this.m_fClosed) {
                    this.m_fClosed = true;
                    if (tracerFin instanceof Closeable) {
                        try {
                            tracerFin.close();
                        }
                        catch (IOException e) {
                            Supplier<String> supplierMsg = () -> String.format("Exception raised closing tracer [%s]:", tracerFin.getClass().getName());
                            Logger.finest(supplierMsg, (Throwable)e);
                        }
                    }
                    AbstractOpenTracingShim.this.onControlClose();
                }
            }

            @Override
            public TracingShim.Dependencies getDependencies() {
                return depsFin;
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return GlobalTracer.isRegistered();
    }

    @Override
    public Tracer getTracer() {
        return this.m_tracer;
    }

    @Override
    public Span getNoopSpan() {
        return NOOP_SPAN;
    }

    @Override
    public Span.Builder getNoopSpanBuilder() {
        return NOOP_BUILDER;
    }

    @Override
    public TracingShim.Dependencies getDependencies() {
        return this.m_dependencies;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    private static boolean checkTracingEnabled(float flSamplingRatio) {
        return flSamplingRatio >= 0.0f && flSamplingRatio <= 1.0f;
    }

    private static void configureTracingSampling(float flSamplingRatio) {
        if (!AbstractOpenTracingShim.isSet(JAEGER_SAMPLER_TYPE_PROPERTY)) {
            System.setProperty(JAEGER_SAMPLER_TYPE_PROPERTY, JAEGER_DEFAULT_SAMPLER_TYPE);
            System.setProperty(JAEGER_SAMPLER_VALUE_PROPERTY, Float.compare(0.0f, flSamplingRatio) == 0 ? "1.0" : String.valueOf(flSamplingRatio));
        }
    }

    private static boolean isSet(String sPropOrEnvName) {
        return System.getProperty(sPropOrEnvName) != null || System.getenv(sPropOrEnvName) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractOpenTracingShim)) {
            return false;
        }
        AbstractOpenTracingShim that = (AbstractOpenTracingShim)o;
        return this.getDependencies().equals(that.getDependencies()) && this.getTracer().equals(that.getTracer());
    }

    public int hashCode() {
        return Objects.hash(this.getDependencies(), this.getTracer());
    }

    public String toString() {
        return "OpenTracingShim(API-Version=" + this.getApiVersion() + ", Dependencies=" + String.valueOf(this.getDependencies()) + ", Tracer=" + String.valueOf(this.getTracer()) + ")";
    }
}

