/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentelemetry;

import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryScope;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryShimLoader;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetrySpan;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetrySpanContext;
import com.tangosol.util.LiteMap;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public class OpenTelemetryTracer
implements Tracer {
    public static final String SCOPE_NAME = "oracle.coherence";

    @Override
    public Span getCurrentSpan() {
        io.opentelemetry.api.trace.Span activeSpan = io.opentelemetry.api.trace.Span.current();
        return activeSpan == null || !activeSpan.getSpanContext().isValid() ? null : new OpenTelemetrySpan(activeSpan);
    }

    @Override
    public Scope withSpan(Span span) {
        return new OpenTelemetryScope(((io.opentelemetry.api.trace.Span)span.underlying()).makeCurrent());
    }

    @Override
    public Span.Builder spanBuilder(String spanName) {
        return new SpanBuilder(this.getTracer().spanBuilder(spanName));
    }

    @Override
    public Map<String, String> inject(SpanContext spanContext) {
        LiteMap<String, String> injectTarget = new LiteMap<String, String>();
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        propagator.inject(Context.current(), injectTarget, (TextMapSetter)new MapSetter());
        return injectTarget;
    }

    @Override
    public SpanContext extract(Map<String, String> carrier) {
        LiteMap extractTarget = new LiteMap();
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        return new OpenTelemetrySpanContext(io.opentelemetry.api.trace.Span.fromContext((Context)propagator.extract(Context.current(), extractTarget, (TextMapGetter)new MapGetter())).getSpanContext());
    }

    @Override
    public boolean isNoop() {
        return OpenTelemetryShimLoader.Noops.isNoop(this.getTracer());
    }

    @Override
    public <T> T underlying() {
        return (T)this.getTracer();
    }

    public String toString() {
        return "OpenTelemetryTracer()";
    }

    private io.opentelemetry.api.trace.Tracer getTracer() {
        return GlobalOpenTelemetry.getTracer((String)SCOPE_NAME);
    }

    protected static class SpanBuilder
    implements Span.Builder {
        private static final String SPAN_KIND = "span.kind";
        private final io.opentelemetry.api.trace.SpanBuilder f_spanBuilder;

        public SpanBuilder(io.opentelemetry.api.trace.SpanBuilder spanBuilder) {
            Objects.requireNonNull(spanBuilder, "Parameter spanBuilder cannot be null");
            this.f_spanBuilder = spanBuilder;
        }

        @Override
        public Span.Builder setParent(Span parent) {
            if (parent != null) {
                this.f_spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)parent.underlying()));
            }
            return this;
        }

        @Override
        public Span.Builder setParent(SpanContext remoteParent) {
            if (remoteParent != null) {
                this.f_spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)io.opentelemetry.api.trace.Span.wrap((io.opentelemetry.api.trace.SpanContext)((io.opentelemetry.api.trace.SpanContext)remoteParent.underlying()))));
            }
            return this;
        }

        @Override
        public Span.Builder setNoParent() {
            this.f_spanBuilder.setNoParent();
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, String sValue) {
            if (sKey != null && !sKey.isEmpty()) {
                if (SPAN_KIND.equals(sKey)) {
                    this.f_spanBuilder.setSpanKind(SpanKind.valueOf((String)sValue.toUpperCase()));
                } else {
                    this.f_spanBuilder.setAttribute(sKey, sValue);
                }
            }
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, boolean fValue) {
            if (sKey != null && !sKey.isEmpty()) {
                this.f_spanBuilder.setAttribute(sKey, fValue);
            }
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, long lValue) {
            if (sKey != null && !sKey.isEmpty()) {
                this.f_spanBuilder.setAttribute(sKey, lValue);
            }
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, double dValue) {
            if (sKey != null && !sKey.isEmpty()) {
                this.f_spanBuilder.setAttribute(sKey, dValue);
            }
            return this;
        }

        @Override
        public Span.Builder withAssociation(String sLabel, SpanContext associatedContext) {
            this.f_spanBuilder.addLink((io.opentelemetry.api.trace.SpanContext)associatedContext.underlying());
            return this;
        }

        @Override
        public Span.Builder setStartTimestamp(long ldtStartTime) {
            this.f_spanBuilder.setStartTimestamp(Instant.ofEpochMilli(ldtStartTime));
            return this;
        }

        @Override
        public Span startSpan() {
            return new OpenTelemetrySpan(this.f_spanBuilder.startSpan());
        }
    }

    private static final class MapSetter
    implements TextMapSetter<Map<String, String>> {
        private MapSetter() {
        }

        public void set(Map<String, String> carrier, String sKey, String sValue) {
            if (carrier != null) {
                carrier.put(sKey, sValue);
            }
        }
    }

    private static final class MapGetter
    implements TextMapGetter<Map<String, String>> {
        private MapGetter() {
        }

        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        public String get(Map<String, String> carrier, String sKey) {
            return carrier == null ? null : carrier.get(sKey);
        }
    }
}

