/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentelemetry;

import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryShimLoader;
import java.util.Objects;

public class OpenTelemetrySpanContext
implements SpanContext {
    protected final io.opentelemetry.api.trace.SpanContext f_spanContext;
    protected final boolean f_fNoop;

    public OpenTelemetrySpanContext(io.opentelemetry.api.trace.SpanContext spanContext) {
        Objects.requireNonNull(spanContext, "Parameter openTracingSpanContext cannot be null");
        this.f_spanContext = spanContext;
        this.f_fNoop = OpenTelemetryShimLoader.Noops.isNoop(spanContext);
    }

    @Override
    public String getTraceId() {
        return this.f_spanContext.getTraceId();
    }

    @Override
    public String getSpanId() {
        return this.f_spanContext.getSpanId();
    }

    @Override
    public boolean isNoop() {
        return this.f_fNoop;
    }

    @Override
    public <T> T underlying() {
        return (T)this.f_spanContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenTelemetrySpanContext)) {
            return false;
        }
        OpenTelemetrySpanContext that = (OpenTelemetrySpanContext)o;
        return this.f_fNoop == that.f_fNoop && Objects.equals(this.f_spanContext, that.f_spanContext);
    }

    public int hashCode() {
        return Objects.hash(this.f_spanContext, this.f_fNoop);
    }

    public String toString() {
        return "OpenTelemetrySpanContext{SpanContext=" + String.valueOf(this.f_spanContext) + ", Noop=" + this.f_fNoop + "}";
    }
}

