/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentelemetry;

import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetrySpanContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class OpenTelemetrySpan
implements Span {
    protected final io.opentelemetry.api.trace.Span f_span;
    protected final SpanContext f_spanContext;
    protected final boolean f_fNoop;

    public OpenTelemetrySpan(io.opentelemetry.api.trace.Span span) {
        Objects.requireNonNull(span, "Parameter span cannot be null");
        this.f_span = span;
        this.f_spanContext = new OpenTelemetrySpanContext(span.getSpanContext());
        this.f_fNoop = !span.isRecording();
    }

    @Override
    public Span setMetadata(String sKey, String sValue) {
        if (sKey != null) {
            this.f_span.setAttribute(sKey, sValue);
        }
        return this;
    }

    @Override
    public Span setMetadata(String sKey, long lValue) {
        if (sKey != null) {
            this.f_span.setAttribute(sKey, lValue);
        }
        return this;
    }

    @Override
    public Span setMetadata(String sKey, double dValue) {
        if (sKey != null) {
            this.f_span.setAttribute(sKey, dValue);
        }
        return this;
    }

    @Override
    public Span setMetadata(String sKey, boolean fValue) {
        if (sKey != null) {
            this.f_span.setAttribute(sKey, fValue);
        }
        return this;
    }

    @Override
    public Span log(String sEvent) {
        if (sEvent != null && !sEvent.isEmpty()) {
            this.f_span.addEvent(sEvent);
        }
        return this;
    }

    @Override
    public Span log(Map<String, ? super Serializable> mapFields) {
        if (mapFields != null && !mapFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int nCount = mapFields.size();
            for (Map.Entry<String, ? super Serializable> e : mapFields.entrySet()) {
                sb.append(e.getKey()).append(": ").append(e.getValue().toString());
                if (--nCount == 0) continue;
                sb.append(", ");
            }
            this.f_span.addEvent(sb.toString());
        }
        return this;
    }

    @Override
    public Span updateName(String sName) {
        if (sName != null) {
            this.f_span.updateName(sName);
        }
        return this;
    }

    @Override
    public void end() {
        this.f_span.end();
    }

    @Override
    public SpanContext getContext() {
        return this.f_spanContext;
    }

    @Override
    public boolean isNoop() {
        return this.f_fNoop;
    }

    @Override
    public <T> T underlying() {
        return (T)this.f_span;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        return this.f_fNoop == that.f_fNoop && Objects.equals(this.f_span, that.f_span) && Objects.equals(this.f_spanContext, that.f_spanContext);
    }

    public int hashCode() {
        return Objects.hash(this.f_span, this.f_spanContext, this.f_fNoop);
    }

    public String toString() {
        return "OpenTelemetrySpan{Span=" + String.valueOf(this.f_span) + ", SpanContext=" + String.valueOf(this.f_spanContext) + ", Noop=" + this.f_fNoop + "}";
    }
}

