/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentelemetry;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.tracing.TracingShimLoader;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryShim;
import com.tangosol.util.Base;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;

public class OpenTelemetryShimLoader
implements TracingShimLoader {
    protected static final Map<String, String> EXPECTED_CLASSES = Map.of("io.opentelemetry.api.OpenTelemetry", "opentelemetry-api", "io.opentelemetry.context.Context", "opentelemetry-context", "io.opentelemetry.sdk.OpenTelemetrySdk", "opentracing-util");
    protected static final boolean ENABLED = Config.getBoolean("com.oracle.coherence.opentelemetry.enabled", true);

    @Override
    public TracingShim loadTracingShim() {
        if (ENABLED) {
            return this.ensureDependenciesPresent() ? new OpenTelemetryShim() : TracingShim.Noop.INSTANCE;
        }
        return null;
    }

    protected boolean ensureDependenciesPresent() {
        ClassLoader loader = Base.getContextClassLoader();
        ArrayList<String> listMissingDeps = null;
        for (Map.Entry<String, String> entry : EXPECTED_CLASSES.entrySet()) {
            String sClassName = entry.getKey();
            if (this.ensureClassPresent(sClassName, loader)) continue;
            if (listMissingDeps == null) {
                listMissingDeps = new ArrayList<String>(EXPECTED_CLASSES.size());
            }
            listMissingDeps.add(entry.getValue());
        }
        if (listMissingDeps != null) {
            Logger.finest(MessageFormat.format("OpenTelemetry support will not be enabled.  The following dependencies appear to be missing: {0}", listMissingDeps));
            return false;
        }
        return true;
    }

    protected boolean ensureClassPresent(String sClassName, ClassLoader classLoader) {
        try {
            Class.forName(sClassName, false, classLoader);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static final class Noops {
        static final Class<? extends Tracer> f_clzNoopTracer;
        static final Class<? extends Scope> f_clzNoopScope;

        Noops() {
        }

        static boolean isNoop(Tracer tracer) {
            return f_clzNoopTracer.isInstance(tracer);
        }

        static boolean isNoop(SpanContext spanContext) {
            return !spanContext.isValid();
        }

        static boolean isNoop(Scope scope) {
            return f_clzNoopScope.isInstance(scope);
        }

        static {
            TracerProvider p = TracerProvider.noop();
            Tracer t = p.get("oracle.coherence");
            f_clzNoopTracer = t.getClass();
            f_clzNoopScope = Scope.noop().getClass();
        }
    }
}

