/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentelemetry;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetrySpan;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryTracer;
import com.tangosol.util.Base;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;

public class OpenTelemetryShim
implements TracingShim {
    protected static final OpenTelemetrySpan NOOP_SPAN = new OpenTelemetrySpan(io.opentelemetry.api.trace.Span.getInvalid());
    protected static final OpenTelemetryTracer.SpanBuilder NOOP_BUILDER;
    protected static final Field GLOBAL_TELEMETRY_REGISTERED_FIELD;
    protected static final Field OBFUSCATED_TELEMETRY_DELEGATE_FIELD;
    protected static final float TRACING_LOWER_SAMPLE_RANGE = 0.0f;
    protected static final float TRACING_UPPER_SAMPLE_RANGE = 1.0f;
    protected static final String OTEL_SAMPLER_TYPE_PROPERTY = "otel.traces.sampler";
    protected static final String OTEL_SAMPLER_VALUE_PROPERTY = "parentbased_traceidratio";
    protected static final String OTEL_TRACES_SAMPLER_ARG_PROPERTY = "otel.traces.sampler.arg";
    protected static final OpenTelemetry INTERNAL_NOOP;
    protected TracingShim.Dependencies m_dependencies;
    protected Tracer m_tracer;

    @Override
    public Span activateSpan(Span span) {
        if (span != null) {
            ((io.opentelemetry.api.trace.Span)span.underlying()).makeCurrent();
        }
        return span;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public TracingShim.Control initialize(TracingShim.Dependencies dependencies) {
        this.m_dependencies = new TracingShim.DefaultDependencies(dependencies);
        final TracingShim.DefaultDependencies depsFin = this.m_dependencies;
        this.m_tracer = new OpenTelemetryTracer();
        if (this.isEnabled()) {
            return null;
        }
        float flSamplingRatio = dependencies.getSamplingRatio();
        if (OpenTelemetryShim.checkTracingEnabled(flSamplingRatio)) {
            OpenTelemetryShim.configureTracingSampling(flSamplingRatio);
            OpenTelemetry underlying = OpenTelemetryShim.getUnderlying();
            if (underlying != null && !INTERNAL_NOOP.equals((Object)underlying)) {
                return null;
            }
            if (INTERNAL_NOOP.equals((Object)underlying)) {
                GlobalOpenTelemetry.resetForTest();
                GlobalEventEmitterProvider.resetForTest();
            }
            GlobalOpenTelemetry.get();
        }
        Logger.finest(() -> "Initialized TracingShim: " + String.valueOf(this));
        return new TracingShim.Control(){
            private boolean m_fClosed;

            @Override
            public synchronized void close() {
                if (!this.m_fClosed) {
                    this.m_fClosed = true;
                    try {
                        Object oDelegate;
                        OpenTelemetry ot = (OpenTelemetry)GLOBAL_TELEMETRY_REGISTERED_FIELD.get(null);
                        if (ot != null && (oDelegate = OBFUSCATED_TELEMETRY_DELEGATE_FIELD.get(ot)) instanceof Closeable) {
                            ((Closeable)oDelegate).close();
                        }
                    }
                    catch (IOException | IllegalAccessException e) {
                        throw Base.ensureRuntimeException(e);
                    }
                    GlobalOpenTelemetry.resetForTest();
                    GlobalEventEmitterProvider.resetForTest();
                    GlobalOpenTelemetry.set((OpenTelemetry)INTERNAL_NOOP);
                }
            }

            @Override
            public TracingShim.Dependencies getDependencies() {
                return depsFin;
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return OpenTelemetryShim.isTelemetryRegistered();
    }

    @Override
    public Tracer getTracer() {
        return this.m_tracer;
    }

    @Override
    public Span getNoopSpan() {
        return NOOP_SPAN;
    }

    @Override
    public Span.Builder getNoopSpanBuilder() {
        return NOOP_BUILDER;
    }

    @Override
    public TracingShim.Dependencies getDependencies() {
        return this.m_dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenTelemetryShim)) {
            return false;
        }
        OpenTelemetryShim that = (OpenTelemetryShim)o;
        return Objects.equals(this.getDependencies(), that.getDependencies()) && Objects.equals(this.getTracer(), that.getTracer());
    }

    public int hashCode() {
        return Objects.hash(this.getDependencies(), this.getTracer());
    }

    public String toString() {
        return "OpenTelemetryShim(Dependencies=" + String.valueOf(this.getDependencies()) + ", Tracer=" + String.valueOf(this.getTracer()) + ")";
    }

    private static boolean isTelemetryRegistered() {
        OpenTelemetry otelActual = OpenTelemetryShim.getUnderlying();
        if (otelActual == null || INTERNAL_NOOP.equals((Object)otelActual)) {
            return false;
        }
        return !OpenTelemetry.noop().equals((Object)otelActual);
    }

    private static OpenTelemetry getUnderlying() {
        try {
            OpenTelemetry otel = (OpenTelemetry)GLOBAL_TELEMETRY_REGISTERED_FIELD.get(null);
            if (otel == null) {
                return null;
            }
            return (OpenTelemetry)OBFUSCATED_TELEMETRY_DELEGATE_FIELD.get(otel);
        }
        catch (IllegalAccessException iae) {
            throw Base.ensureRuntimeException(iae);
        }
    }

    private static boolean checkTracingEnabled(float flSamplingRatio) {
        return flSamplingRatio >= 0.0f && flSamplingRatio <= 1.0f;
    }

    private static boolean isSet(String sPropOrEnvName) {
        return System.getProperty(sPropOrEnvName) != null || System.getenv(sPropOrEnvName) != null;
    }

    private static void configureTracingSampling(float flSamplingRatio) {
        if (!OpenTelemetryShim.isSet(OTEL_SAMPLER_TYPE_PROPERTY)) {
            System.setProperty(OTEL_SAMPLER_TYPE_PROPERTY, OTEL_SAMPLER_VALUE_PROPERTY);
            System.setProperty(OTEL_TRACES_SAMPLER_ARG_PROPERTY, Float.compare(0.0f, flSamplingRatio) == 0 ? "1.0" : String.valueOf(flSamplingRatio));
        }
    }

    static {
        INTERNAL_NOOP = new InternalNoopTelemetry();
        TracerProvider p = TracerProvider.noop();
        io.opentelemetry.api.trace.Tracer t = p.get("oracle.coherence");
        NOOP_BUILDER = new OpenTelemetryTracer.SpanBuilder(t.spanBuilder("noop")){

            @Override
            public Span startSpan() {
                return NOOP_SPAN;
            }
        };
        Field fieldRegistered = null;
        try {
            fieldRegistered = GlobalOpenTelemetry.class.getDeclaredField("globalOpenTelemetry");
            fieldRegistered.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Logger.err("An incompatible version of the OpenTelemetry API has been detected on the classpath. Tracing will be disabled.");
        }
        GLOBAL_TELEMETRY_REGISTERED_FIELD = fieldRegistered;
        try {
            Field fieldDelegate = Class.forName(GlobalOpenTelemetry.class.getName() + "$ObfuscatedOpenTelemetry").getDeclaredField("delegate");
            fieldDelegate.setAccessible(true);
            OBFUSCATED_TELEMETRY_DELEGATE_FIELD = fieldDelegate;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class InternalNoopTelemetry
    implements OpenTelemetry {
        public TracerProvider getTracerProvider() {
            return TracerProvider.noop();
        }

        public ContextPropagators getPropagators() {
            return ContextPropagators.noop();
        }
    }
}

