/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.utilint;

import com.tangosol.internal.sleepycat.utilint.ActivityCounter;
import com.tangosol.internal.sleepycat.utilint.LatencyStat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StatsTracker<T> {
    private final Map<T, LatencyStat> intervalLatencies = new HashMap<T, LatencyStat>();
    private final Map<T, LatencyStat> cumulativeLatencies = new HashMap<T, LatencyStat>();
    private final ActivityCounter activityCounter;

    public StatsTracker(T[] opTypes, Logger stackTraceLogger, int activeThreadThreshold, long threadDumpIntervalMillis, int threadDumpMax, int maxTrackedLatencyMillis) {
        for (T opType : opTypes) {
            this.intervalLatencies.put(opType, new LatencyStat(maxTrackedLatencyMillis));
            this.cumulativeLatencies.put(opType, new LatencyStat(maxTrackedLatencyMillis));
        }
        this.activityCounter = new ActivityCounter(activeThreadThreshold, threadDumpIntervalMillis, threadDumpMax, stackTraceLogger);
    }

    public long markStart() {
        this.activityCounter.start();
        return System.nanoTime();
    }

    public void markFinish(T opType, long startTime) {
        this.markFinish(opType, startTime, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFinish(T opType, long startTime, int numOperations) {
        try {
            if (numOperations == 0) {
                return;
            }
            if (opType != null) {
                long elapsed = System.nanoTime() - startTime;
                this.intervalLatencies.get(opType).set(numOperations, elapsed);
                this.cumulativeLatencies.get(opType).set(numOperations, elapsed);
            }
        }
        finally {
            this.activityCounter.finish();
        }
    }

    public void clearLatency() {
        for (Map.Entry<T, LatencyStat> e : this.intervalLatencies.entrySet()) {
            e.getValue().clear();
        }
    }

    public Map<T, LatencyStat> getIntervalLatency() {
        return this.intervalLatencies;
    }

    public Map<T, LatencyStat> getCumulativeLatency() {
        return this.cumulativeLatencies;
    }

    public int getNumCompletedDumps() {
        return this.activityCounter.getNumCompletedDumps();
    }
}

