/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.persist.evolve.Converter;
import com.tangosol.internal.sleepycat.persist.impl.Accessor;
import com.tangosol.internal.sleepycat.persist.impl.Catalog;
import com.tangosol.internal.sleepycat.persist.impl.EntityInput;
import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.Reader;
import com.tangosol.internal.sleepycat.persist.impl.RefreshException;
import com.tangosol.internal.sleepycat.persist.model.EntityModel;
import com.tangosol.internal.sleepycat.persist.raw.RawObject;

public class ConverterReader
implements Reader {
    private static final long serialVersionUID = -305788321064984348L;
    private Converter converter;
    private transient Format oldFormat;

    ConverterReader(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormat) {
        this.oldFormat = oldFormat;
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
        return this.oldFormat.newInstance(input, true);
    }

    @Override
    public void readPriKey(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        this.oldFormat.readPriKey(o, input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        Catalog catalog = input.getCatalog();
        boolean currentRawMode = input.setRawAccess(true);
        try {
            o = this.oldFormat.readObject(o, input, true);
        }
        finally {
            input.setRawAccess(currentRawMode);
        }
        o = this.converter.getConversion().convert(o);
        if (!rawAccess && o instanceof RawObject) {
            o = catalog.convertRawObject((RawObject)o, null);
        }
        return o;
    }

    @Override
    public Accessor getAccessor(boolean rawAccess) {
        return this.oldFormat.getAccessor(rawAccess);
    }
}

