/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.ExceptionListener;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StoppableThread
extends Thread {
    protected final EnvironmentImpl envImpl;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Exception savedShutdownException = null;
    private long totalCpuTime = -1L;
    private long totalUserTime = -1L;

    protected StoppableThread(String threadName) {
        this(null, null, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, String threadName) {
        this(envImpl, null, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, Thread.UncaughtExceptionHandler handler, String threadName) {
        this(envImpl, handler, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, Thread.UncaughtExceptionHandler handler, Runnable runnable, String threadName) {
        super(null, runnable, threadName);
        this.envImpl = envImpl;
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(handler == null ? new UncaughtHandler() : handler);
    }

    protected abstract Logger getLogger();

    public Exception getSavedShutdownException() {
        return this.savedShutdownException;
    }

    public void saveShutdownException(Exception shutdownException) {
        this.savedShutdownException = shutdownException;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    protected boolean shutdownDone() {
        return !this.shutdown.compareAndSet(false, true);
    }

    protected void cleanup() {
    }

    public void shutdownThread(Logger logger) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (threadBean.isThreadCpuTimeSupported()) {
            this.totalCpuTime = threadBean.getThreadCpuTime(this.getId());
            this.totalUserTime = threadBean.getThreadUserTime(this.getId());
        } else if (threadBean.isCurrentThreadCpuTimeSupported() && Thread.currentThread() == this) {
            this.totalCpuTime = threadBean.getCurrentThreadCpuTime();
            this.totalUserTime = threadBean.getCurrentThreadUserTime();
        }
        if (Thread.currentThread() == this) {
            return;
        }
        try {
            LoggerUtils.info(logger, this.envImpl, this.getName() + " soft shutdown initiated.");
            int waitMs = this.initiateSoftShutdown();
            if (waitMs >= 0) {
                this.join(waitMs);
            }
            if (this.isAlive()) {
                LoggerUtils.warning(logger, this.envImpl, "Soft shutdown failed for thread:" + this + " after waiting for " + waitMs + "ms resorting to interrupt.");
                this.interrupt();
                this.join();
                LoggerUtils.warning(logger, this.envImpl, this + " shutdown via interrupt.");
            } else {
                LoggerUtils.fine(logger, this.envImpl, this + " has exited.");
            }
        }
        catch (InterruptedException e1) {
            LoggerUtils.warning(logger, this.envImpl, "Interrupted while waiting to join thread:" + this);
        }
    }

    protected int initiateSoftShutdown() {
        return -1;
    }

    public long getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public long getTotalUserTime() {
        return this.totalUserTime;
    }

    private class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger useLogger = StoppableThread.this.getLogger();
            if (useLogger != null) {
                String envName = StoppableThread.this.envImpl == null ? "" : StoppableThread.this.envImpl.getName();
                String message = envName + ":" + t.getName() + " exited unexpectedly with exception " + e;
                if (e != null) {
                    message = message + LoggerUtils.getStackTrace(e);
                }
                if (StoppableThread.this.envImpl != null) {
                    LoggerUtils.severe(useLogger, StoppableThread.this.envImpl, message);
                } else {
                    useLogger.log(Level.SEVERE, message);
                }
            }
            if (StoppableThread.this.envImpl == null) {
                return;
            }
            ExceptionListener exceptionListener = StoppableThread.this.envImpl.getExceptionListener();
            if (exceptionListener != null && e instanceof Exception) {
                exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent((Exception)e, t.getName()));
            }
            if (StoppableThread.this.envImpl.isValid()) {
                new EnvironmentFailureException(StoppableThread.this.envImpl, EnvironmentFailureReason.UNCAUGHT_EXCEPTION, e);
            }
        }
    }
}

