/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.ExceptionListener;
import com.tangosol.internal.sleepycat.je.LockConflictException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.utilint.DaemonRunner;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaemonThread
implements DaemonRunner,
Runnable {
    private static final int JOIN_MILLIS = 10;
    private volatile long waitTime;
    private final Object synchronizer = new Object();
    private Thread thread;
    protected String name;
    protected int nWakeupRequests;
    public static boolean stifleExceptionChatter = false;
    private volatile boolean shutdownRequest = false;
    private volatile boolean paused = false;
    private boolean running = false;
    protected final EnvironmentImpl envImpl;
    private static final String ERROR_LISTENER = "setErrorListener";
    protected final Logger logger;

    public DaemonThread(long waitTime, String name, EnvironmentImpl envImpl) {
        this.waitTime = waitTime;
        String nodeName = envImpl.getOptionalNodeName();
        this.name = nodeName == null ? name : name + " (" + nodeName + ")";
        this.envImpl = envImpl;
        this.logger = this.createLogger();
    }

    protected Logger createLogger() {
        return LoggerUtils.getLogger(this.getClass());
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void runOrPause(boolean run) {
        if (run) {
            this.paused = false;
            if (this.thread != null) {
                this.wakeup();
            } else {
                this.thread = new Thread((Runnable)this, this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        } else {
            this.paused = true;
        }
    }

    @Override
    public void requestShutdown() {
        this.shutdownRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.thread != null) {
            this.shutdownRequest = true;
            while (this.thread.isAlive()) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.synchronizer.notifyAll();
                }
                try {
                    this.thread.join(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<DaemonThread name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.paused) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdownRequest) {
            try {
                int numTries = 0;
                long maxRetries = this.nDeadlockRetries();
                while ((long)numTries <= maxRetries && !this.shutdownRequest && !this.paused) {
                    try {
                        ++this.nWakeupRequests;
                        this.running = true;
                        this.onWakeup();
                        break;
                    }
                    catch (LockConflictException e) {
                    }
                    finally {
                        this.running = false;
                    }
                    ++numTries;
                }
                if (this.shutdownRequest) continue;
                Object object = this.synchronizer;
                synchronized (object) {
                    if (this.waitTime == 0L || this.paused) {
                        this.synchronizer.wait();
                    } else {
                        this.synchronizer.wait(this.waitTime);
                    }
                }
            }
            catch (InterruptedException e) {
                this.notifyExceptionListener(e);
                if (!stifleExceptionChatter) {
                    this.logger.info("Shutting down " + this + " due to exception: " + e);
                }
                this.shutdownRequest = true;
                assert (this.checkErrorListener(e));
            }
            catch (Exception e) {
                this.notifyExceptionListener(e);
                if (!stifleExceptionChatter) {
                    this.logger.log(Level.SEVERE, this.toString() + " caught exception, " + e + (this.shutdownRequest ? " Exiting" : " Continuing"), e);
                }
                assert (this.checkErrorListener(e));
            }
            catch (Error e) {
                assert (this.checkErrorListener(e));
                this.envImpl.invalidate(e);
                this.shutdownRequest = true;
                this.logger.log(Level.SEVERE, "Error caught in " + this, e);
            }
        }
    }

    private void notifyExceptionListener(Exception e) {
        if (this.envImpl == null) {
            return;
        }
        ExceptionListener listener = this.envImpl.getExceptionListener();
        if (listener == null) {
            return;
        }
        listener.exceptionThrown(DbInternal.makeExceptionEvent(e, this.name));
    }

    public boolean checkErrorListener(Throwable e) {
        if (Boolean.getBoolean(ERROR_LISTENER)) {
            if (!stifleExceptionChatter) {
                this.logger.severe(this.name + " " + LoggerUtils.getStackTrace(e));
            }
            new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.TEST_INVALIDATE, "Daemon thread failed during testing", e);
        }
        return true;
    }

    protected long nDeadlockRetries() {
        return 0L;
    }

    protected abstract void onWakeup() throws DatabaseException;

    protected boolean isShutdownRequested() {
        return this.shutdownRequest;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public int getNWakeupRequests() {
        return this.nWakeupRequests;
    }
}

