/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.txn;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.OperationFailureException;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.txn.BasicLocker;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import java.util.Iterator;

public class ThreadLocker
extends BasicLocker {
    private boolean allowMultithreadedAccess;

    public ThreadLocker(EnvironmentImpl env) {
        super(env);
        this.lockManager.registerThreadLocker(this);
    }

    public static ThreadLocker createThreadLocker(EnvironmentImpl env, boolean replicated) throws DatabaseException {
        return env.isReplicated() && replicated ? env.createRepThreadLocker() : new ThreadLocker(env);
    }

    @Override
    void close() {
        super.close();
        this.lockManager.unregisterThreadLocker(this);
    }

    @Override
    public void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        Iterator<ThreadLocker> iter = this.lockManager.getThreadLockers(this.thread);
        while (iter.hasNext()) {
            ThreadLocker locker = iter.next();
            locker.throwIfPreempted(allowPreemptedLocker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lockAfterLsnChange(long oldLsn, long newLsn, DatabaseImpl dbImpl) {
        boolean oldVal = this.allowMultithreadedAccess;
        this.allowMultithreadedAccess = true;
        try {
            super.lockAfterLsnChange(oldLsn, newLsn, dbImpl);
        }
        finally {
            this.allowMultithreadedAccess = oldVal;
        }
    }

    @Override
    protected synchronized void checkState(boolean ignoreCalledByAbort) {
        if (!this.allowMultithreadedAccess && this.thread != Thread.currentThread()) {
            throw new IllegalStateException("Non-transactional Cursors may not be used in multiple threads; Cursor was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    @Override
    public Locker newNonTxnLocker() throws DatabaseException {
        this.checkState(false);
        return this.newEmptyThreadLockerClone();
    }

    public ThreadLocker newEmptyThreadLockerClone() {
        return new ThreadLocker(this.envImpl);
    }

    @Override
    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (other instanceof ThreadLocker) {
            return this.thread == other.thread;
        }
        return false;
    }
}

