/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.txn;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.CursorImpl;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.txn.Lock;
import com.tangosol.internal.sleepycat.je.txn.LockGrantType;
import com.tangosol.internal.sleepycat.je.txn.LockResult;
import com.tangosol.internal.sleepycat.je.txn.LockStatDefinition;
import com.tangosol.internal.sleepycat.je.txn.LockType;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.Txn;
import com.tangosol.internal.sleepycat.je.txn.TxnManager;
import com.tangosol.internal.sleepycat.je.txn.WriteLockInfo;
import com.tangosol.internal.sleepycat.je.utilint.IntStat;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import java.util.HashSet;
import java.util.Set;

public class BasicLocker
extends Locker {
    private Long ownedLock;
    private Set<Long> ownedLockSet;
    private boolean lockingRequired;

    protected BasicLocker(EnvironmentImpl env) {
        super(env, false, false, 0L);
    }

    public static BasicLocker createBasicLocker(EnvironmentImpl env) throws DatabaseException {
        return new BasicLocker(env);
    }

    protected BasicLocker(EnvironmentImpl env, boolean noWait) {
        super(env, false, noWait, 0L);
    }

    public static BasicLocker createBasicLocker(EnvironmentImpl env, boolean noWait) throws DatabaseException {
        return new BasicLocker(env, noWait);
    }

    @Override
    protected long generateId(TxnManager txnManager, long ignore) {
        return -1L;
    }

    @Override
    protected void checkState(boolean ignoreCalledByAbort) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws DatabaseException {
        boolean useNoWait;
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            this.checkState(false);
        }
        long timeout = 0L;
        boolean bl = useNoWait = noWait || this.defaultNoWait;
        if (!useNoWait) {
            BasicLocker basicLocker2 = this;
            synchronized (basicLocker2) {
                timeout = this.getLockTimeout();
            }
        }
        LockGrantType grant = this.lockManager.lock(lsn, this, lockType, timeout, useNoWait, jumpAheadOfWaiters, database);
        return new LockResult(grant, null);
    }

    @Override
    public void preLogWithoutLock(DatabaseImpl database) {
    }

    public Locker getWriteOwnerLocker(long lsn) throws DatabaseException {
        return this.lockManager.getWriteOwnerLocker(lsn);
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isSerializableIsolation() {
        return false;
    }

    @Override
    public boolean isReadCommittedIsolation() {
        return false;
    }

    @Override
    public Txn getTxnLocker() {
        return null;
    }

    @Override
    public Locker newNonTxnLocker() throws DatabaseException {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public synchronized void releaseNonTxnLocks() throws DatabaseException {
        if (this.ownedLock != null) {
            this.lockManager.release(this.ownedLock, this);
            this.ownedLock = null;
        }
        if (this.ownedLockSet != null) {
            for (Long nid : this.ownedLockSet) {
                this.lockManager.release(nid, this);
            }
            this.ownedLockSet.clear();
        }
        if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
            this.envImpl.addToCompressorQueue(this.deleteInfo.values(), false);
            this.deleteInfo.clear();
        }
    }

    @Override
    public void nonTxnOperationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    @Override
    public void operationEnd(boolean operationOK) throws DatabaseException {
        this.releaseNonTxnLocks();
        this.close();
    }

    @Override
    public void registerCursor(CursorImpl cursor) {
        this.lockingRequired = cursor.isInternalDbCursor();
    }

    @Override
    public void unRegisterCursor(CursorImpl cursor) {
    }

    @Override
    public boolean lockingRequired() {
        return this.lockingRequired;
    }

    @Override
    public WriteLockInfo getWriteLockInfo(long lsn) {
        return WriteLockInfo.basicWriteLockInfo;
    }

    @Override
    public void markDeleteAtTxnEnd(DatabaseImpl db, boolean deleteAtCommit) throws DatabaseException {
        if (deleteAtCommit) {
            db.startAndFinishDelete();
        } else {
            this.envImpl.getDbTree().releaseDb(db);
        }
    }

    @Override
    protected void addLock(Long lsn, LockType type, LockGrantType grantStatus) {
        if (this.ownedLock != null && this.ownedLock.equals(lsn) || this.ownedLockSet != null && this.ownedLockSet.contains(lsn)) {
            return;
        }
        if (this.ownedLock == null) {
            this.ownedLock = lsn;
        } else {
            if (this.ownedLockSet == null) {
                this.ownedLockSet = new HashSet<Long>();
            }
            this.ownedLockSet.add(lsn);
        }
    }

    @Override
    void removeLock(long lsn) {
        if (this.ownedLock != null && this.ownedLock == lsn) {
            this.ownedLock = null;
        } else if (this.ownedLockSet != null) {
            this.ownedLockSet.remove(lsn);
        }
    }

    @Override
    void moveWriteToReadLock(long lsn, Lock lock) {
    }

    @Override
    public StatGroup collectStats() throws DatabaseException {
        Lock l;
        StatGroup stats = new StatGroup("Locker lock counts", "Read and write locks held by this locker");
        IntStat nReadLocks = new IntStat(stats, LockStatDefinition.LOCK_READ_LOCKS);
        IntStat nWriteLocks = new IntStat(stats, LockStatDefinition.LOCK_WRITE_LOCKS);
        if (this.ownedLock != null && (l = this.lockManager.lookupLock(this.ownedLock)) != null) {
            if (l.isOwnedWriteLock(this)) {
                nWriteLocks.increment();
            } else {
                nReadLocks.increment();
            }
        }
        if (this.ownedLockSet != null) {
            for (Long nid : this.ownedLockSet) {
                Lock l2 = this.lockManager.lookupLock(nid);
                if (l2 == null) continue;
                if (l2.isOwnedWriteLock(this)) {
                    nWriteLocks.increment();
                    continue;
                }
                nReadLocks.increment();
            }
        }
        return stats;
    }
}

