/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.tree.dupConvert;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.MemoryBudget;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.tree.BIN;
import com.tangosol.internal.sleepycat.je.tree.Key;
import com.tangosol.internal.sleepycat.je.tree.TreeUtils;
import com.tangosol.internal.sleepycat.je.utilint.SizeofMarker;
import java.nio.ByteBuffer;

public final class DBIN
extends BIN
implements Loggable {
    private static final String BEGIN_TAG = "<dbin>";
    private static final String END_TAG = "</dbin>";
    private byte[] dupKey;

    public DBIN() {
    }

    public DBIN(SizeofMarker marker) {
        super(marker);
        this.dupKey = null;
    }

    @Override
    public boolean isDBIN() {
        return true;
    }

    @Override
    public boolean containsDuplicates() {
        return true;
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.DBIN_FIXED_OVERHEAD;
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.beginTag());
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.endTag());
        return sb.toString();
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_DBIN;
    }

    @Override
    public int getLogSize() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer, entryVersion < 6);
    }

    @Override
    protected void dumpLogAdditional(StringBuilder sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
    }

    @Override
    public String shortClassName() {
        return "DBIN";
    }
}

