/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.utilint.net;

import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.ReplicationNetworkConfig;
import com.tangosol.internal.sleepycat.je.rep.net.DataChannelFactory;
import com.tangosol.internal.sleepycat.je.rep.net.InstanceContext;
import com.tangosol.internal.sleepycat.je.rep.net.InstanceLogger;
import com.tangosol.internal.sleepycat.je.rep.net.InstanceParams;
import com.tangosol.internal.sleepycat.je.rep.net.LoggerFactory;
import com.tangosol.internal.sleepycat.je.rep.utilint.net.SSLChannelFactory;
import com.tangosol.internal.sleepycat.je.rep.utilint.net.SimpleChannelFactory;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.TracerFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataChannelFactoryBuilder {
    private static final AtomicInteger factoryCount = new AtomicInteger(0);

    public static DataChannelFactory constructDefault() {
        return new SimpleChannelFactory();
    }

    public static DataChannelFactory construct(ReplicationNetworkConfig repNetConfig) throws IllegalArgumentException {
        return DataChannelFactoryBuilder.construct(repNetConfig, (String)null);
    }

    public static DataChannelFactory construct(ReplicationNetworkConfig repNetConfig, String logContext) throws IllegalArgumentException {
        String logName = repNetConfig.getLogName();
        if (logName.isEmpty() && (logContext == null || logContext.isEmpty())) {
            return DataChannelFactoryBuilder.construct(repNetConfig, (LoggerFactory)null);
        }
        String logId = logName.isEmpty() ? logContext : (logContext == null || logContext.isEmpty() ? logName : logName + ":" + logContext);
        LoggerFactory loggerFactory = DataChannelFactoryBuilder.makeLoggerFactory(logId);
        return DataChannelFactoryBuilder.construct(repNetConfig, loggerFactory);
    }

    public static DataChannelFactory construct(ReplicationNetworkConfig repNetConfig, LoggerFactory loggerFactory) throws IllegalArgumentException {
        String channelType = repNetConfig.getChannelType();
        int factoryIndex = factoryCount.getAndIncrement();
        if (loggerFactory == null) {
            String logName = repNetConfig.getLogName();
            if (logName.isEmpty()) {
                logName = Integer.toString(factoryIndex);
            }
            loggerFactory = DataChannelFactoryBuilder.makeLoggerFactory(logName);
        }
        InstanceContext context = new InstanceContext(repNetConfig, loggerFactory);
        String factoryClass = repNetConfig.getChannelFactoryClass();
        if (factoryClass == null || factoryClass.isEmpty()) {
            if (channelType.equalsIgnoreCase("basic")) {
                return new SimpleChannelFactory(new InstanceParams(context, null));
            }
            if (channelType.equalsIgnoreCase("ssl")) {
                return new SSLChannelFactory(new InstanceParams(context, null));
            }
            throw new IllegalArgumentException("The channelType setting '" + channelType + "' is not valid");
        }
        String classParams = repNetConfig.getChannelFactoryParams();
        InstanceParams factoryParams = new InstanceParams(context, classParams);
        return DataChannelFactoryBuilder.construct(factoryClass, factoryParams);
    }

    private static DataChannelFactory construct(String factoryClassName, InstanceParams factoryParams) throws IllegalArgumentException {
        return (DataChannelFactory)DataChannelFactoryBuilder.constructObject(factoryClassName, DataChannelFactory.class, "data channel factory", new CtorArgSpec(new Class[]{InstanceParams.class}, new Object[]{factoryParams}));
    }

    static Object constructObject(String instClassName, Class<?> mustImplement, String miDesc, CtorArgSpec ctorArgSpec) throws IllegalArgumentException {
        Object instObject;
        Constructor<?> constructor;
        Class<?> instClass = null;
        try {
            instClass = Class.forName(instClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Error resolving " + miDesc + " class " + instClassName, cnfe);
        }
        try {
            constructor = instClass.getConstructor(ctorArgSpec.argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Unable to find an appropriate constructor for " + miDesc + " class " + instClassName);
        }
        try {
            instObject = constructor.newInstance(ctorArgSpec.argValues);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Error instantiating " + miDesc + " class " + instClassName + ".  Not accessible?", iae);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Error instantiating " + miDesc + " class " + instClassName, iae);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Error instantiating " + miDesc + " class " + instClassName + ". Class is abstract?", ie);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Error instantiating " + miDesc + " class " + instClassName + ". Exception within constructor", ite);
        }
        if (!mustImplement.isAssignableFrom(instObject.getClass())) {
            throw new IllegalArgumentException("The " + miDesc + " class " + instClassName + " does not implement " + mustImplement.getName());
        }
        return instObject;
    }

    public static LoggerFactory makeLoggerFactory(EnvironmentImpl envImpl) {
        if (envImpl == null) {
            throw new IllegalArgumentException("envImpl must not be null");
        }
        return new ChannelLoggerFactory(envImpl, null);
    }

    public static LoggerFactory makeLoggerFactory(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        ChannelFormatter formatter = new ChannelFormatter(prefix);
        return new ChannelLoggerFactory(null, formatter);
    }

    static class ChannelFormatter
    extends TracerFormatter {
        private final String id;

        ChannelFormatter(String id) {
            this.id = id;
        }

        @Override
        protected void appendEnvironmentName(StringBuilder sb) {
            sb.append(" [" + this.id + "]");
        }
    }

    static class ChannelInstanceLogger
    implements InstanceLogger {
        private final EnvironmentImpl envImpl;
        private final Formatter formatter;
        private final Logger logger;

        ChannelInstanceLogger(EnvironmentImpl envImpl, Formatter formatter, Logger logger) {
            this.envImpl = envImpl;
            this.formatter = formatter;
            this.logger = logger;
        }

        @Override
        public void log(Level logLevel, String msg) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, logLevel, msg);
        }
    }

    static class ChannelLoggerFactory
    implements LoggerFactory {
        private final EnvironmentImpl envImpl;
        private final Formatter formatter;

        ChannelLoggerFactory(EnvironmentImpl envImpl, Formatter formatter) {
            this.envImpl = envImpl;
            this.formatter = formatter;
        }

        @Override
        public InstanceLogger getLogger(Class<?> clazz) {
            Logger logger = this.envImpl == null ? LoggerUtils.getLoggerFormatterNeeded(clazz) : LoggerUtils.getLogger(clazz);
            return new ChannelInstanceLogger(this.envImpl, this.formatter, logger);
        }
    }

    static class CtorArgSpec {
        private final Class<?>[] argTypes;
        private final Object[] argValues;

        CtorArgSpec(Class<?>[] argTypes, Object[] argValues) {
            this.argTypes = argTypes;
            this.argValues = argValues;
        }
    }
}

