/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.util.ldiff;

import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.util.Arrays;

public class Record {
    private final byte[] key;
    private final byte[] data;
    private final VLSN vlsn;
    byte[] mix;

    public Record(byte[] key, byte[] data, VLSN vlsn) {
        this.key = key;
        this.data = data;
        this.vlsn = vlsn;
    }

    private void generateMix() {
        this.mix = new byte[this.key.length + this.data.length];
        System.arraycopy(this.key, 0, this.mix, 0, this.key.length);
        System.arraycopy(this.data, 0, this.mix, this.key.length, this.data.length);
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }

    public VLSN getVLSN() {
        return this.vlsn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        return Arrays.equals(record.getKey(), this.getKey()) && Arrays.equals(record.getData(), this.getData());
    }

    public int hashCode() {
        if (this.mix == null && this.key != null && this.data != null) {
            this.generateMix();
        }
        return Arrays.hashCode(this.mix);
    }
}

