/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.txn;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.LockConflictException;
import com.tangosol.internal.sleepycat.je.LockNotAvailableException;
import com.tangosol.internal.sleepycat.je.ReplicaConsistencyPolicy;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.internal.sleepycat.je.TransactionConfig;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.ReplicationContext;
import com.tangosol.internal.sleepycat.je.rep.MasterStateException;
import com.tangosol.internal.sleepycat.je.rep.ReplicaConsistencyException;
import com.tangosol.internal.sleepycat.je.rep.ReplicaWriteException;
import com.tangosol.internal.sleepycat.je.rep.ReplicatedEnvironment;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.txn.LockResult;
import com.tangosol.internal.sleepycat.je.txn.LockType;
import com.tangosol.internal.sleepycat.je.txn.Txn;

public class ReadonlyTxn
extends Txn {
    private final boolean localWrite;

    public ReadonlyTxn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config, ReplicationContext.NO_REPLICATE);
        this.localWrite = config.getLocalWrite();
    }

    @Override
    public boolean isLocalWrite() {
        return this.localWrite;
    }

    @Override
    public LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws LockNotAvailableException, LockConflictException, DatabaseException {
        if (lockType.isWriteLock() && !database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        return super.lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
    }

    @Override
    public void preLogWithoutLock(DatabaseImpl database) {
        if (!database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        super.preLogWithoutLock(database);
    }

    @Override
    public void disallowReplicaWrite() {
        throw new ReplicaWriteException(this, ((RepImpl)this.envImpl).getStateChangeEvent());
    }

    @Override
    protected void txnBeginHook(TransactionConfig config) throws ReplicaConsistencyException, DatabaseException {
        ReadonlyTxn.checkConsistency((RepImpl)this.envImpl, config.getConsistencyPolicy());
    }

    static void checkConsistency(RepImpl repImpl, ReplicaConsistencyPolicy policy) {
        if (ReplicatedEnvironment.State.DETACHED.equals((Object)repImpl.getState()) || ReplicatedEnvironment.State.MASTER.equals((Object)repImpl.getState())) {
            return;
        }
        assert (policy != null) : "Missing default consistency policy";
        try {
            policy.ensureConsistency(repImpl);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException((EnvironmentImpl)repImpl, (Throwable)e);
        }
        catch (MasterStateException e) {
            return;
        }
    }
}

