/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.stream;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.LogEntryHeader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

abstract class WireRecord {
    final LogEntryHeader header;

    WireRecord(LogEntryHeader header) {
        this.header = header;
    }

    LogEntryType getLogEntryType() throws DatabaseException {
        LogEntryType type = LogEntryType.findType(this.header.getType());
        if (type == null) {
            throw EnvironmentFailureException.unexpectedState("Unknown header type:" + this.header.getType());
        }
        return type;
    }

    LogEntry instantiateEntry(EnvironmentImpl envImpl, ByteBuffer buffer) throws DatabaseException {
        LogEntry entry = this.getLogEntryType().getNewLogEntry();
        buffer.mark();
        entry.readEntry(envImpl, this.header, buffer);
        buffer.reset();
        return entry;
    }
}

