/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.stream;

import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.Timestamp;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MatchpointSearchResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long matchpointLSN = DbLsn.makeLsn(0L, 0);
    private boolean passedCheckpointEnd;
    private boolean passedSkippedGap;
    private final List<PassedTxnInfo> passedTxns;
    private final int passedTxnLimit;
    private PassedTxnInfo earliestPassedTxn;
    private PassedTxnInfo penultimatePassedTxn;
    private int numPassedCommits;

    public MatchpointSearchResults(EnvironmentImpl envImpl) {
        this.passedTxnLimit = envImpl.getConfigManager().getInt(RepParams.TXN_ROLLBACK_LIMIT);
        this.passedTxns = new ArrayList<PassedTxnInfo>();
        this.numPassedCommits = 0;
    }

    void notePassedCheckpointEnd() {
        this.passedCheckpointEnd = true;
    }

    void noteSkippedGap() {
        this.passedSkippedGap = true;
    }

    void setMatchpoint(long match) {
        this.matchpointLSN = match;
        if (this.earliestPassedTxn != null && this.earliestPassedTxn.lsn == this.matchpointLSN) {
            --this.numPassedCommits;
            if (this.passedTxns.size() > 0) {
                int lastSavedTxn = this.passedTxns.size() - 1;
                if (this.passedTxns.get((int)lastSavedTxn).lsn == match) {
                    this.passedTxns.remove(lastSavedTxn);
                }
                this.earliestPassedTxn = this.penultimatePassedTxn;
            }
        }
    }

    void notePassedCommits(Timestamp commitTime, long txnId, VLSN vlsn, long lsn) {
        ++this.numPassedCommits;
        if (this.earliestPassedTxn != null) {
            this.penultimatePassedTxn = this.earliestPassedTxn;
        }
        this.earliestPassedTxn = new PassedTxnInfo(commitTime, txnId, vlsn, lsn);
        if (this.numPassedCommits <= this.passedTxnLimit) {
            this.passedTxns.add(this.earliestPassedTxn);
        }
    }

    boolean getPassedCheckpointEnd() {
        return this.passedCheckpointEnd;
    }

    boolean getSkippedGap() {
        return this.passedSkippedGap;
    }

    public long getMatchpointLSN() {
        return this.matchpointLSN;
    }

    public int getNumPassedCommits() {
        return this.numPassedCommits;
    }

    public PassedTxnInfo getEarliestPassedTxn() {
        return this.earliestPassedTxn;
    }

    public String dumpPassedTxns() {
        StringBuilder sb = new StringBuilder();
        for (PassedTxnInfo info : this.passedTxns) {
            sb.append(info);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return "matchpointLSN=" + DbLsn.getNoFormatString(this.matchpointLSN) + " passedCkpt=" + this.passedCheckpointEnd + " passedTxnLimit=" + this.passedTxnLimit + " passedTxns=" + this.passedTxns + " earliestTxn=" + this.earliestPassedTxn + " penultimateTxn=" + this.penultimatePassedTxn + " numPassedCommits=" + this.numPassedCommits + " passedSkippedGap=" + this.passedSkippedGap;
    }

    public String getRollbackMsg() {
        if (this.numPassedCommits == 0) {
            return " uncommitted operations";
        }
        return " " + this.numPassedCommits + " commits to the earliest point indicated by transaction " + this.earliestPassedTxn;
    }

    public static class PassedTxnInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Timestamp time;
        public final long id;
        public final VLSN vlsn;
        public final long lsn;

        PassedTxnInfo(Timestamp time, long id, VLSN vlsn, long lsn) {
            this.time = time;
            this.id = id;
            this.vlsn = vlsn;
            this.lsn = lsn;
        }

        public String toString() {
            return "id=" + this.id + " time=" + this.time + " vlsn=" + this.vlsn + " lsn=" + DbLsn.getNoFormatString(this.lsn);
        }
    }
}

