/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl.node;

import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;

class JoinGroupTimeouts {
    private final int unknownStateTimeout;
    private final int setupTimeout;
    private int timeout;
    private final long start = System.currentTimeMillis();

    JoinGroupTimeouts(DbConfigManager configManager) {
        this.setupTimeout = configManager.getDuration(RepParams.ENV_SETUP_TIMEOUT);
        if (configManager.getDuration(RepParams.ENV_UNKNOWN_STATE_TIMEOUT) == 0) {
            boolean allowUnknownStateEnv = configManager.getBoolean(RepParams.ALLOW_UNKNOWN_STATE_ENV_OPEN);
            this.unknownStateTimeout = allowUnknownStateEnv ? this.setupTimeout : Integer.MAX_VALUE;
        } else {
            this.unknownStateTimeout = configManager.getDuration(RepParams.ENV_UNKNOWN_STATE_TIMEOUT);
            if (this.unknownStateTimeout > this.setupTimeout) {
                String message = String.format(" The timeout ENV_UNKNOWN_STATE_TIMEOUT(%,d ms) exceeds the timeout ENV_SETUP_TIMEOUT(%,d ms)", this.unknownStateTimeout, this.setupTimeout);
                throw new IllegalArgumentException(message);
            }
        }
        this.timeout = Math.min(this.unknownStateTimeout, this.setupTimeout);
    }

    int getTimeout() {
        return Math.max(this.timeout - (int)(System.currentTimeMillis() - this.start), 0);
    }

    public int getSetupTimeout() {
        return this.setupTimeout;
    }

    boolean timeoutIsForUnknownState() {
        return this.timeout == this.unknownStateTimeout;
    }

    void setSetupTimeout() {
        this.timeout = this.setupTimeout;
    }
}

