/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl;

import com.tangosol.internal.sleepycat.je.config.BooleanConfigParam;
import com.tangosol.internal.sleepycat.je.config.ConfigParam;
import com.tangosol.internal.sleepycat.je.config.DurationConfigParam;
import com.tangosol.internal.sleepycat.je.config.IntConfigParam;
import com.tangosol.internal.sleepycat.je.config.LongConfigParam;
import com.tangosol.internal.sleepycat.je.rep.NodeType;
import com.tangosol.internal.sleepycat.je.rep.impl.EnumConfigParam;
import com.tangosol.internal.sleepycat.je.rep.utilint.RepUtils;
import com.tangosol.internal.sleepycat.je.rep.utilint.net.SSLChannelFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.StringTokenizer;

public class RepParams {
    public static final String SKIP_NODENAME_VALIDATION = "je.rep.skipNodenameValidation";
    public static final ConfigParam GROUP_NAME = new IdentifierConfigParam("je.rep.groupName", "DefaultGroup", false, true);
    public static final DurationConfigParam REP_STREAM_TIMEOUT = new DurationConfigParam("je.rep.repStreamTimeout", null, null, "24 h", false, true);
    public static final IntConfigParam MIN_RETAINED_VLSNS = new IntConfigParam("je.rep.minRetainedVLSNs", 0, null, 200000, false, true);
    public static final IntConfigParam REPLICA_RECEIVE_BUFFER_SIZE = new IntConfigParam("je.rep.replicaReceiveBufferSize", 0, null, 0x100000, false, true);
    public static final IntConfigParam REPLICA_MESSAGE_QUEUE_SIZE = new IntConfigParam("je.rep.replicaMessageQueueSize", 1, null, 1000, true, true);
    public static final DurationConfigParam REPLAY_TXN_LOCK_TIMEOUT = new DurationConfigParam("je.rep.replayTxnLockTimeout", "1 ms", "75 min", "500 ms", false, true);
    public static final DurationConfigParam ENV_SETUP_TIMEOUT = new DurationConfigParam("je.rep.envSetupTimeout", null, null, "10 h", false, true);
    public static final DurationConfigParam ENV_CONSISTENCY_TIMEOUT = new DurationConfigParam("je.rep.envConsistencyTimeout", "10 ms", null, "5 min", false, true);
    public static final DurationConfigParam ENV_UNKNOWN_STATE_TIMEOUT = new DurationConfigParam("je.rep.envUnknownStateTimeout", null, null, "0 s", false, true);
    public static final DurationConfigParam REPLICA_ACK_TIMEOUT = new DurationConfigParam("je.rep.replicaAckTimeout", "10 ms", null, "5 s", false, true);
    public static final DurationConfigParam INSUFFICIENT_REPLICAS_TIMEOUT = new DurationConfigParam("je.rep.insufficientReplicasTimeout", "10 ms", null, "10 s", false, true);
    public static final BooleanConfigParam ENABLE_GROUP_ACKS = new BooleanConfigParam("je.rep.enableGroupAcks", false, false, true);
    public static final LongConfigParam MAX_MESSAGE_SIZE = new LongConfigParam("je.rep.maxMessageSize", 262144L, Long.MAX_VALUE, 0L, false, true);
    public static final ConfigParam CONSISTENCY_POLICY = new ConfigParam("je.rep.consistencyPolicy", "TimeConsistencyPolicy(1 s,1 h)", false, true){

        @Override
        public void validateValue(String propertyValue) throws IllegalArgumentException {
            RepUtils.getReplicaConsistencyPolicy(propertyValue);
        }
    };
    public static final IntConfigParam DEFAULT_PORT = new IntConfigParam("je.rep.defaultPort", 1024, (Integer)Short.MAX_VALUE, 5001, false, true);
    public static final ConfigParam NODE_HOST_PORT = new ConfigParam("je.rep.nodeHostPort", "localhost", false, true){

        @Override
        public void validateValue(String hostAndPort) throws IllegalArgumentException {
            if (hostAndPort == null || hostAndPort.length() == 0) {
                throw new IllegalArgumentException("The value cannot be null or zero length: " + this.name);
            }
            int colonToken = hostAndPort.indexOf(":");
            String hostName = colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
            ServerSocket testSocket = null;
            try {
                testSocket = new ServerSocket();
                testSocket.bind(new InetSocketAddress(hostName, 0));
                testSocket.close();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Property: " + this.name + " Invalid hostname: " + hostName, e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Property: " + this.name + " Invalid hostname: " + hostName, e);
            }
            if (colonToken >= 0) {
                RepParams.validatePort(hostAndPort.substring(colonToken + 1));
            }
        }
    };
    public static final ConfigParam NODE_NAME = new IdentifierConfigParam("je.rep.nodeName", "DefaultRepNodeName", false, true);
    public static final EnumConfigParam<NodeType> NODE_TYPE = new EnumConfigParam<NodeType>("je.rep.nodeType", NodeType.ELECTABLE, false, true, NodeType.class);
    public static final IntConfigParam NODE_PRIORITY = new IntConfigParam("je.rep.node.priority", 0, Integer.MAX_VALUE, 1, true, true);
    public static final BooleanConfigParam DESIGNATED_PRIMARY = new BooleanConfigParam("je.rep.designatedPrimary", false, true, true);
    public static final BooleanConfigParam FEEDER_TCP_NO_DELAY = new BooleanConfigParam("je.rep.feederTcpNoDelay", true, false, true);
    public static final IntConfigParam FEEDER_BATCH_NS = new IntConfigParam("je.rep.feederBatchNs", 0, Integer.MAX_VALUE, 1000000, true, true);
    public static final IntConfigParam FEEDER_BATCH_BUFF_KB = new IntConfigParam("je.rep.feederBatchBuffKb", 4, Integer.MAX_VALUE, 64, true, true);
    public static final IntConfigParam ELECTABLE_GROUP_SIZE_OVERRIDE = new IntConfigParam("je.rep.electableGroupSizeOverride", 0, Integer.MAX_VALUE, 0, true, true);
    public static final BooleanConfigParam RESET_REP_GROUP = new BooleanConfigParam("je.rep.resetRepGroup", false, false, true);
    public static final BooleanConfigParam RESET_REP_GROUP_RETAIN_UUID = new BooleanConfigParam("je.rep.resetRepGroupRetainUUID", false, false, true);
    public static final BooleanConfigParam IGNORE_SECONDARY_NODE_ID = new BooleanConfigParam("je.rep.ignoreSecondaryNodeId", false, false, true);
    public static final DurationConfigParam MAX_CLOCK_DELTA = new DurationConfigParam("je.rep.maxClockDelta", null, "1 min", "2 s", false, true);
    public static final ConfigParam HELPER_HOSTS = new ConfigParam("je.rep.helperHosts", "", true, true){

        @Override
        public void validateValue(String hostPortPairs) throws IllegalArgumentException {
            if (hostPortPairs == null || hostPortPairs.length() == 0) {
                return;
            }
            HashSet<String> hostPortSet = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(hostPortPairs, ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String hostPortPair = tokenizer.nextToken();
                    if (!hostPortSet.add(hostPortPair)) {
                        throw new IllegalArgumentException("Property: " + this.name + " Duplicate specification: " + hostPortPair);
                    }
                    RepParams.validateHostAndPort(hostPortPair);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Property: " + this.name + "Error: " + iae.getMessage(), iae);
                }
            }
        }
    };
    public static final IntConfigParam HEARTBEAT_INTERVAL = new IntConfigParam("je.rep.heartbeatInterval", 1000, null, 1000, false, true);
    public static final IntConfigParam DBTREE_CACHE_CLEAR_COUNT = new IntConfigParam("je.rep.dbIdCacheOpCount", 1, null, 5000, false, true);
    public static final IntConfigParam VLSN_STRIDE = new IntConfigParam("je.rep.vlsn.stride", 1, null, 10, false, true);
    public static final IntConfigParam VLSN_MAX_MAP = new IntConfigParam("je.rep.vlsn.mappings", 1, null, 1000, false, true);
    public static final IntConfigParam VLSN_MAX_DIST = new IntConfigParam("je.rep.vlsn.distance", 1, null, 100000, false, true);
    public static final IntConfigParam TEST_REPLICA_DELAY = new IntConfigParam("je.rep.test.replicaDelay", 0, Integer.MAX_VALUE, 0, false, true);
    public static final IntConfigParam VLSN_LOG_CACHE_SIZE = new IntConfigParam("je.rep.vlsn.logCacheSize", 0, 1024, 32, false, true);
    public static final DurationConfigParam REPSTREAM_OPEN_TIMEOUT = new DurationConfigParam("je.rep.repstreamOpenTimeout", null, "5 min", "5 s", false, true);
    public static final DurationConfigParam ELECTIONS_OPEN_TIMEOUT = new DurationConfigParam("je.rep.electionsOpenTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam ELECTIONS_READ_TIMEOUT = new DurationConfigParam("je.rep.electionsReadTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam ELECTIONS_REBROADCAST_PERIOD = new DurationConfigParam("je.rep.electionsRebroadcastPeriod", null, null, "1 min", false, true);
    public static final IntConfigParam ELECTIONS_PRIMARY_RETRIES = new IntConfigParam("je.rep.electionsPrimaryRetries", 0, Integer.MAX_VALUE, 2, false, true);
    public static final DurationConfigParam REP_GROUP_OPEN_TIMEOUT = new DurationConfigParam("je.rep.repGroupOpenTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam REP_GROUP_READ_TIMEOUT = new DurationConfigParam("je.rep.repGroupReadTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam MONITOR_OPEN_TIMEOUT = new DurationConfigParam("je.rep.monitorOpenTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam MONITOR_READ_TIMEOUT = new DurationConfigParam("je.rep.monitorReadTimeout", null, "1 min", "10 s", false, true);
    public static final DurationConfigParam REPLICA_TIMEOUT = new DurationConfigParam("je.rep.replicaTimeout", "2 s", null, "30 s", false, true);
    public static final IntConfigParam REPLAY_MAX_OPEN_DB_HANDLES = new IntConfigParam("je.rep.replayMaxOpenDbHandles", 1, Integer.MAX_VALUE, 10, true, true);
    public static final DurationConfigParam REPLAY_DB_HANDLE_TIMEOUT = new DurationConfigParam("je.rep.replayOpenHandleTimeout", "1 s", null, "30 s", true, true);
    public static final IntConfigParam REPLICA_MAX_GROUP_COMMIT = new IntConfigParam("je.rep.replicaMaxGroupCommit", 0, null, 200, false, true);
    public static final DurationConfigParam REPLICA_GROUP_COMMIT_INTERVAL = new DurationConfigParam("je.rep.replicaGroupCommitInterval", "0 ms", null, "3 ms", false, true);
    public static final IntConfigParam FEEDER_HEARTBEAT_TIMEOUT = new IntConfigParam("je.rep.feederHeartbeatTrigger", 0, Integer.MAX_VALUE, 4, false, true);
    public static final BooleanConfigParam SO_REUSEADDR = new BooleanConfigParam("je.rep.soReuseAddr", false, false, true);
    public static final BooleanConfigParam BIND_INADDR_ANY = new BooleanConfigParam("je.rep.bindInaddrAny", false, false, true);
    public static final IntConfigParam SO_BIND_WAIT_MS = new IntConfigParam("je.rep.retrySocketBind", 0, 150000, 0, false, true);
    public static final DurationConfigParam FEEDER_TIMEOUT = new DurationConfigParam("je.rep.feederTimeout", "2 s", null, "30 s", false, true);
    public static final DurationConfigParam TRANSFER_LOGGING_THRESHOLD = new DurationConfigParam("je.rep.transferLoggingThreshold", "1 ms", null, "5 s", false, true);
    public static final DurationConfigParam REPLAY_LOGGING_THRESHOLD = new DurationConfigParam("je.rep.replayLoggingThreshold", "1 ms", null, "5 s", false, true);
    public static final BooleanConfigParam COMMIT_TO_NETWORK = new BooleanConfigParam("je.rep.commitToNetwork", false, false, true);
    public static final DurationConfigParam PRE_HEARTBEAT_TIMEOUT = new DurationConfigParam("je.rep.preHeartbeatTimeoutMs", "1 s", null, "60 s", false, true);
    public static final IntConfigParam TXN_ROLLBACK_LIMIT = new IntConfigParam("je.rep.txnRollbackLimit", 0, Integer.MAX_VALUE, 10, false, true);
    public static final BooleanConfigParam RUN_LOG_FLUSH_TASK = new BooleanConfigParam("je.rep.runLogFlushTask", true, true, true);
    public static final DurationConfigParam LOG_FLUSH_TASK_INTERVAL = new DurationConfigParam("je.rep.logFlushTaskInterval", "1 s", null, "5 min", true, true);
    public static final BooleanConfigParam ALLOW_UNKNOWN_STATE_ENV_OPEN = new BooleanConfigParam("je.rep.allowUnknownStateEnvOpen", false, false, true);
    public static final BooleanConfigParam DONT_JOIN_REP_GROUP = new BooleanConfigParam("je.rep.dontJoinRepGroup", false, false, true);
    public static final BooleanConfigParam PRESERVE_RECORD_VERSION = new BooleanConfigParam("je.rep.preserveRecordVersion", false, false, true);
    public static final BooleanConfigParam CACHE_RECORD_VERSION = new BooleanConfigParam("je.rep.cacheRecordVersion", true, false, true);
    public static final IntConfigParam CACHED_RECORD_VERSION_MIN_LENGTH = new IntConfigParam("je.rep.cachedRecordVersionMinLength", 1, 8, 5, false, true);
    public static final BooleanConfigParam PROTOCOL_OLD_STRING_ENCODING = new BooleanConfigParam("je.rep.protocolOldStringEncoding", true, false, true);
    public static final ConfigParam CHANNEL_TYPE = new ChannelTypeConfigParam("je.rep.channelType", "basic", false, true);
    public static final ConfigParam CHANNEL_LOG_NAME = new ConfigParam("je.rep.channelLogName", "", false, true);
    public static final ConfigParam CHANNEL_FACTORY_CLASS = new ConfigParam("je.rep.channelFactoryClass", "", false, true);
    public static final ConfigParam CHANNEL_FACTORY_PARAMS = new ConfigParam("je.rep.channelFactoryParams", "", false, true);
    public static final ConfigParam SSL_KEYSTORE_FILE = new ConfigParam("je.rep.ssl.keyStoreFile", "", false, true);
    public static final ConfigParam SSL_KEYSTORE_PASSWORD = new ConfigParam("je.rep.ssl.keyStorePassword", "", false, true);
    public static final ConfigParam SSL_KEYSTORE_PASSWORD_CLASS = new ConfigParam("je.rep.ssl.keyStorePasswordClass", "", false, true);
    public static final ConfigParam SSL_KEYSTORE_PASSWORD_PARAMS = new ConfigParam("je.rep.ssl.keyStorePasswordParams", "", false, true);
    public static final ConfigParam SSL_KEYSTORE_TYPE = new ConfigParam("je.rep.ssl.keyStoreType", "", false, true);
    public static final ConfigParam SSL_SERVER_KEY_ALIAS = new ConfigParam("je.rep.ssl.serverKeyAlias", "", false, true);
    public static final ConfigParam SSL_CLIENT_KEY_ALIAS = new ConfigParam("je.rep.ssl.clientKeyAlias", "", false, true);
    public static final ConfigParam SSL_TRUSTSTORE_FILE = new ConfigParam("je.rep.ssl.trustStoreFile", "", false, true);
    public static final ConfigParam SSL_TRUSTSTORE_TYPE = new ConfigParam("je.rep.ssl.trustStoreType", "", false, true);
    public static final ConfigParam SSL_CIPHER_SUITES = new ConfigParam("je.rep.ssl.cipherSuites", "", false, true);
    public static final ConfigParam SSL_PROTOCOLS = new ConfigParam("je.rep.ssl.protocols", "", false, true);
    public static final ConfigParam SSL_AUTHENTICATOR = new ConfigParam("je.rep.ssl.authenticator", "", false, true){

        @Override
        public void validateValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("a value is required");
            }
            if (!SSLChannelFactory.isValidAuthenticator(value)) {
                throw new IllegalArgumentException(value + " a not a valid value");
            }
        }
    };
    public static final ConfigParam SSL_AUTHENTICATOR_CLASS = new ConfigParam("je.rep.ssl.authenticatorClass", "", false, true);
    public static final ConfigParam SSL_AUTHENTICATOR_PARAMS = new ConfigParam("je.rep.ssl.authenticatorParams", "", false, true);
    public static final ConfigParam SSL_HOST_VERIFIER = new ConfigParam("je.rep.ssl.hostVerifier", "", false, true){

        @Override
        public void validateValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("a value is required");
            }
            if (!SSLChannelFactory.isValidHostVerifier(value)) {
                throw new IllegalArgumentException(value + " a not a valid value");
            }
        }
    };
    public static final ConfigParam SSL_HOST_VERIFIER_CLASS = new ConfigParam("je.rep.ssl.hostVerifierClass", "", false, true);
    public static final ConfigParam SSL_HOST_VERIFIER_PARAMS = new ConfigParam("je.rep.ssl.hostVerifierParams", "", false, true);
    public static final ConfigParam TEST_JE_VERSION = new ConfigParam("je.rep.test.jeVersion", "", false, true);
    public static final IntConfigParam REPLAY_COST_PERCENT = new IntConfigParam("je.rep.replayCostPercent", 0, 200, 150, false, true);
    public static final IntConfigParam REPLAY_FREE_DISK_PERCENT = new IntConfigParam("je.rep.replayFreeDiskPercent", 0, 99, 10, false, true);

    private static void validatePort(String portString) throws IllegalArgumentException {
        try {
            int port = Integer.parseInt(portString);
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("Invalid port number: " + portString);
            }
            if (port <= 1023) {
                throw new IllegalArgumentException("Port number " + port + " is invalid because the port must be outside the range of \"well known\" ports");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port number: " + portString);
        }
    }

    private static void validateHostAndPort(String hostAndPort) throws IllegalArgumentException {
        String hostName;
        int colonToken = hostAndPort.indexOf(":");
        String string = hostName = colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
        if ("".equals(hostName)) {
            throw new IllegalArgumentException("missing hostname");
        }
        try {
            InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid hostname: " + e.getMessage());
        }
        if (colonToken >= 0) {
            RepParams.validatePort(hostAndPort.substring(colonToken + 1));
        }
    }

    public static class ChannelTypeConfigParam
    extends ConfigParam {
        public static final String BASIC = "basic";
        public static final String SSL = "ssl";
        public static final String CUSTOM = "custom";
        private static final String DEBUG_NAME = ChannelTypeConfigParam.class.getName();

        public ChannelTypeConfigParam(String configName, String defaultValue, boolean mutable, boolean forReplication) {
            super(configName, defaultValue, mutable, forReplication);
        }

        @Override
        public void validateValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException(DEBUG_NAME + ": a value is required");
            }
            if (!(BASIC.equals(value) || SSL.equals(value) || CUSTOM.equals(value))) {
                throw new IllegalArgumentException(DEBUG_NAME + ": " + value + " a not a valid value");
            }
        }
    }

    public static class IdentifierConfigParam
    extends ConfigParam {
        private static final String DEBUG_NAME = IdentifierConfigParam.class.getName();

        public IdentifierConfigParam(String configName, String defaultValue, boolean mutable, boolean forReplication) {
            super(configName, defaultValue, mutable, forReplication);
        }

        @Override
        public void validateValue(String value) {
            if (Boolean.getBoolean(RepParams.SKIP_NODENAME_VALIDATION)) {
                return;
            }
            if (value == null || value.length() == 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ": a value is required");
            }
            for (char c : value.toCharArray()) {
                if (this.isValid(c)) continue;
                throw new IllegalArgumentException(DEBUG_NAME + ": " + this.name + ", must consist of " + "letters, digits, hyphen, underscore, period.");
            }
        }

        private boolean isValid(char c) {
            return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.';
        }
    }
}

