/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl;

import com.tangosol.internal.sleepycat.je.rep.impl.NodeStateProtocol;
import com.tangosol.internal.sleepycat.je.rep.impl.TextProtocol;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.rep.net.DataChannel;
import com.tangosol.internal.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.util.logging.Logger;

public class NodeStateService
extends ServiceDispatcher.ExecutingService {
    private final RepNode repNode;
    private final NodeStateProtocol protocol;
    private final Logger logger;
    public static final String SERVICE_NAME = "NodeState";

    public NodeStateService(ServiceDispatcher dispatcher, RepNode repNode) {
        super(SERVICE_NAME, dispatcher);
        this.repNode = repNode;
        String groupName = repNode.getRepImpl().cloneRepConfig().getGroupName();
        this.protocol = new NodeStateProtocol(groupName, repNode.getNameIdPair(), repNode.getRepImpl(), dispatcher.getChannelFactory());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public TextProtocol.ResponseMessage process(NodeStateProtocol.NodeStateRequest stateRequest) {
        long joinTime = this.repNode.getMonitorEventManager().getJoinTime();
        NodeStateProtocol nodeStateProtocol = this.protocol;
        nodeStateProtocol.getClass();
        return nodeStateProtocol.new NodeStateProtocol.NodeStateResponse(this.repNode.getNodeName(), this.repNode.getMasterName(), joinTime, this.repNode.getRepImpl().getState());
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new NodeStateServiceRunnable(dataChannel, this.protocol);
    }

    class NodeStateServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        NodeStateServiceRunnable(DataChannel dataChannel, NodeStateProtocol protocol) {
            super(dataChannel, protocol, true);
        }

        @Override
        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            return this.protocol.process(NodeStateService.this, request);
        }

        @Override
        protected void logMessage(String message) {
            LoggerUtils.warning(NodeStateService.this.logger, NodeStateService.this.repNode.getRepImpl(), message);
        }
    }
}

