/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.elections;

import com.tangosol.internal.sleepycat.je.JEVersion;
import com.tangosol.internal.sleepycat.je.rep.elections.Proposer;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.impl.TextProtocol;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.rep.net.DataChannelFactory;

public class Protocol
extends TextProtocol {
    private static final String VERSION = "2.0";
    private final Proposer.ProposalParser proposalParser;
    private final ValueParser valueParser;
    public final TextProtocol.MessageOp PROPOSE = new TextProtocol.MessageOp("P", Propose.class);
    public final TextProtocol.MessageOp ACCEPT = new TextProtocol.MessageOp("A", Accept.class);
    public final TextProtocol.MessageOp RESULT = new TextProtocol.MessageOp("RE", Result.class);
    public final TextProtocol.MessageOp MASTER_QUERY = new TextProtocol.MessageOp("MQ", MasterQuery.class);
    public final TextProtocol.MessageOp SHUTDOWN = new TextProtocol.MessageOp("X", Shutdown.class);
    public final TextProtocol.MessageOp REJECT = new TextProtocol.MessageOp("R", Reject.class);
    public final TextProtocol.MessageOp PROMISE = new TextProtocol.MessageOp("PR", Promise.class);
    public final TextProtocol.MessageOp ACCEPTED = new TextProtocol.MessageOp("AD", Accepted.class);
    public final TextProtocol.MessageOp MASTER_QUERY_RESPONSE = new TextProtocol.MessageOp("MQR", MasterQueryResponse.class);

    public Protocol(Proposer.ProposalParser proposalParser, ValueParser valueParser, String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        super(VERSION, groupName, nameIdPair, repImpl, channelFactory);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.PROPOSE, this.ACCEPT, this.RESULT, this.MASTER_QUERY, this.SHUTDOWN, this.REJECT, this.PROMISE, this.ACCEPTED, this.MASTER_QUERY_RESPONSE});
        this.proposalParser = proposalParser;
        this.valueParser = valueParser;
        this.setTimeouts(repImpl, RepParams.ELECTIONS_OPEN_TIMEOUT, RepParams.ELECTIONS_READ_TIMEOUT);
    }

    public static class StringValue
    extends TextProtocol.StringFormatable
    implements Value {
        StringValue() {
            super(null);
        }

        public StringValue(String s) {
            super(s);
        }

        public String toString() {
            return "Value:" + this.s;
        }

        public String getString() {
            return this.s;
        }
    }

    public static interface ValueParser {
        public Value parse(String var1);
    }

    public static interface Value
    extends TextProtocol.WireFormatable {
    }

    public class MasterQuery
    extends TextProtocol.RequestMessage {
        public MasterQuery() {
            super(Protocol.this);
        }

        public MasterQuery(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, responseLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.MASTER_QUERY;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix();
        }

        public String toString() {
            return this.getOp() + " " + this.getMessagePrefix() + " " + this.wireFormat();
        }
    }

    public class Result
    extends Accept {
        Result(Proposer.Proposal proposal, Value value) {
            super(proposal, value);
        }

        public Result(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(requestLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.RESULT;
        }
    }

    public class Accept
    extends Propose {
        private final Value value;

        Accept(Proposer.Proposal proposal, Value value) {
            super(proposal);
            this.value = value;
        }

        public Accept(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(requestLine, tokens);
            this.value = Protocol.this.valueParser.parse(this.nextPayloadToken());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Accept)) {
                return false;
            }
            Accept other = (Accept)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.ACCEPT;
        }

        @Override
        public String wireFormat() {
            return super.wireFormat() + "|" + this.value.wireFormat();
        }

        Value getValue() {
            return this.value;
        }
    }

    public class Shutdown
    extends TextProtocol.RequestMessage {
        public Shutdown() {
            super(Protocol.this);
        }

        public Shutdown(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, responseLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.SHUTDOWN;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix();
        }
    }

    public class Propose
    extends TextProtocol.RequestMessage {
        protected final Proposer.Proposal proposal;

        Propose(Proposer.Proposal proposal) {
            super(Protocol.this);
            this.proposal = proposal;
        }

        public Propose(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, requestLine, tokens);
            this.proposal = Protocol.this.proposalParser.parse(this.nextPayloadToken());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.proposal == null ? 0 : this.proposal.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Propose)) {
                return false;
            }
            Propose other = (Propose)obj;
            return !(this.proposal == null ? other.proposal != null : !this.proposal.equals(other.proposal));
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.PROPOSE;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.proposal.wireFormat();
        }

        Proposer.Proposal getProposal() {
            return this.proposal;
        }
    }

    public class Reject
    extends TextProtocol.ResponseMessage {
        private final Proposer.Proposal higherProposal;

        Reject(Proposer.Proposal higherProposal) {
            super(Protocol.this);
            this.higherProposal = higherProposal;
        }

        public Reject(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, responseLine, tokens);
            this.higherProposal = Protocol.this.proposalParser.parse(this.nextPayloadToken());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.higherProposal == null ? 0 : this.higherProposal.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Reject)) {
                return false;
            }
            Reject other = (Reject)obj;
            return !(this.higherProposal == null ? other.higherProposal != null : !this.higherProposal.equals(other.higherProposal));
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.REJECT;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.higherProposal.wireFormat();
        }

        Proposer.Proposal getHigherProposal() {
            return this.higherProposal;
        }
    }

    public class MasterQueryResponse
    extends Accepted {
        MasterQueryResponse(Proposer.Proposal proposal, Value value) {
            super(proposal, value);
        }

        public MasterQueryResponse(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(responseLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.MASTER_QUERY_RESPONSE;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }
    }

    public class Accepted
    extends TextProtocol.ResponseMessage {
        private final Proposer.Proposal proposal;
        private final Value value;

        Accepted(Proposer.Proposal proposal, Value value) {
            super(Protocol.this);
            assert (proposal != null);
            assert (value != null);
            this.proposal = proposal;
            this.value = value;
        }

        public Accepted(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, responseLine, tokens);
            this.proposal = Protocol.this.proposalParser.parse(this.nextPayloadToken());
            this.value = Protocol.this.valueParser.parse(this.nextPayloadToken());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.proposal == null ? 0 : this.proposal.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Accepted)) {
                return false;
            }
            Accepted other = (Accepted)obj;
            if (this.proposal == null ? other.proposal != null : !this.proposal.equals(other.proposal)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.ACCEPTED;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.proposal.wireFormat() + "|" + this.value.wireFormat();
        }

        public Value getValue() {
            return this.value;
        }

        public Proposer.Proposal getProposal() {
            return this.proposal;
        }
    }

    public class Promise
    extends TextProtocol.ResponseMessage {
        private Proposer.Proposal highestProposal;
        private Value acceptedValue;
        private Value suggestion;
        private long suggestionWeight;
        private final int priority;
        private int logVersion;
        private JEVersion jeVersion;

        public Promise(Proposer.Proposal highestProposal, Value value, Value suggestion, long suggestionWeight, int priority, int logVersion, JEVersion jeVersion) {
            super(Protocol.this);
            this.highestProposal = null;
            this.acceptedValue = null;
            this.suggestion = null;
            this.suggestionWeight = Long.MIN_VALUE;
            this.highestProposal = highestProposal;
            this.acceptedValue = value;
            this.suggestion = suggestion;
            this.suggestionWeight = suggestionWeight;
            this.priority = priority;
            this.logVersion = logVersion;
            this.jeVersion = jeVersion;
        }

        public Promise(String responseLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, responseLine, tokens);
            this.highestProposal = null;
            this.acceptedValue = null;
            this.suggestion = null;
            this.suggestionWeight = Long.MIN_VALUE;
            this.highestProposal = Protocol.this.proposalParser.parse(this.nextPayloadToken());
            this.acceptedValue = Protocol.this.valueParser.parse(this.nextPayloadToken());
            this.suggestion = Protocol.this.valueParser.parse(this.nextPayloadToken());
            String weight = this.nextPayloadToken();
            this.suggestionWeight = "".equals(weight) ? Long.MIN_VALUE : Long.parseLong(weight);
            this.priority = Integer.parseInt(this.nextPayloadToken());
            if (Protocol.this.getMajorVersionNumber(this.sendVersion) > 1) {
                this.logVersion = Integer.parseInt(this.nextPayloadToken());
                this.jeVersion = new JEVersion(this.nextPayloadToken());
            }
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.PROMISE;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.acceptedValue == null ? 0 : this.acceptedValue.hashCode());
            result = 31 * result + (this.highestProposal == null ? 0 : this.highestProposal.hashCode());
            result = 31 * result + this.priority;
            result = 31 * result + (this.suggestion == null ? 0 : this.suggestion.hashCode());
            result = 31 * result + (int)(this.suggestionWeight ^ this.suggestionWeight >>> 32);
            if (Protocol.this.getMajorVersionNumber(this.sendVersion) > 1) {
                result += 31 * result + this.logVersion + this.jeVersion.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Promise other = (Promise)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.acceptedValue == null ? other.acceptedValue != null : !this.acceptedValue.equals(other.acceptedValue)) {
                return false;
            }
            if (this.highestProposal == null ? other.highestProposal != null : !this.highestProposal.equals(other.highestProposal)) {
                return false;
            }
            if (this.priority != other.priority) {
                return false;
            }
            if (Protocol.this.getMajorVersionNumber(this.sendVersion) > 1) {
                if (this.logVersion != other.logVersion) {
                    return false;
                }
                if (this.jeVersion.compareTo(other.jeVersion) != 0) {
                    return false;
                }
            }
            if (this.suggestion == null ? other.suggestion != null : !this.suggestion.equals(other.suggestion)) {
                return false;
            }
            return this.suggestionWeight == other.suggestionWeight;
        }

        @Override
        public String wireFormat() {
            String line = this.wireFormatPrefix() + "|" + (this.highestProposal != null ? this.highestProposal.wireFormat() : "") + "|" + (this.acceptedValue != null ? this.acceptedValue.wireFormat() : "") + "|" + (this.suggestion != null ? this.suggestion.wireFormat() : "") + "|" + (this.suggestionWeight == Long.MIN_VALUE ? "" : Long.toString(this.suggestionWeight)) + "|" + this.priority;
            if (Protocol.this.getMajorVersionNumber(this.sendVersion) > 1) {
                line = line + "|" + this.logVersion + "|" + this.jeVersion.toString();
            }
            return line;
        }

        Proposer.Proposal getHighestProposal() {
            return this.highestProposal;
        }

        Value getAcceptedValue() {
            return this.acceptedValue;
        }

        Value getSuggestion() {
            return this.suggestion;
        }

        long getSuggestionRanking() {
            return this.suggestionWeight;
        }

        int getPriority() {
            return this.priority;
        }

        int getLogVersion() {
            return this.logVersion;
        }

        JEVersion getJEVersion() {
            return this.jeVersion;
        }

        private Protocol getOuterType() {
            return Protocol.this;
        }
    }
}

