/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.RestartRequiredException;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;

public class RollbackException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private final MatchpointSearchResults searchResults;

    public RollbackException(RepImpl repImpl, VLSN matchpointVLSN, MatchpointSearchResults searchResults) {
        super((EnvironmentImpl)repImpl, EnvironmentFailureReason.HARD_RECOVERY, RollbackException.makeMessage(repImpl.getName(), searchResults, matchpointVLSN));
        this.searchResults = searchResults;
    }

    private static String makeMessage(String nodeName, MatchpointSearchResults searchResults, VLSN matchpointVLSN) {
        long matchpointLSN = searchResults.getMatchpointLSN();
        return "Node " + nodeName + " must rollback" + searchResults.getRollbackMsg() + " in order to rejoin the replication group. All existing " + "ReplicatedEnvironment handles must be closed and " + "reinstantiated.  Log files were truncated to file 0x" + DbLsn.getFileNumber(matchpointLSN) + ", offset 0x" + DbLsn.getFileOffset(matchpointLSN) + ", vlsn " + matchpointVLSN;
    }

    public Long getEarliestTransactionCommitTime() {
        if (this.searchResults == null) {
            return null;
        }
        if (this.searchResults.getEarliestPassedTxn() == null) {
            return null;
        }
        return this.searchResults.getEarliestPassedTxn().time.getTime();
    }

    public long getEarliestTransactionId() {
        if (this.searchResults == null) {
            return 0L;
        }
        if (this.searchResults.getEarliestPassedTxn() == null) {
            return 0L;
        }
        return this.searchResults.getEarliestPassedTxn().id;
    }

    public RollbackException(String message, RollbackException cause) {
        super(message + " " + cause.getMessage(), cause);
        this.searchResults = cause.searchResults;
    }

    @Override
    public RollbackException wrapSelf(String msg) {
        return new RollbackException(msg, this);
    }
}

