/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.ProgressListener;
import com.tangosol.internal.sleepycat.je.ReplicaConsistencyPolicy;
import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.dbi.RepConfigProxy;
import com.tangosol.internal.sleepycat.je.rep.LogFileRewriteListener;
import com.tangosol.internal.sleepycat.je.rep.NodeType;
import com.tangosol.internal.sleepycat.je.rep.ReplicationMutableConfig;
import com.tangosol.internal.sleepycat.je.rep.ReplicationNetworkConfig;
import com.tangosol.internal.sleepycat.je.rep.SyncupProgress;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.utilint.HostPortPair;
import com.tangosol.internal.sleepycat.je.rep.utilint.RepUtils;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReplicationConfig
extends ReplicationMutableConfig
implements RepConfigProxy {
    private static final long serialVersionUID = 1L;
    public static final String GROUP_NAME = "je.rep.groupName";
    public static final String NODE_NAME = "je.rep.nodeName";
    public static final String NODE_TYPE = "je.rep.nodeType";
    @Deprecated
    public static final String HELPER_HOSTS = "je.rep.helperHosts";
    public static final String DEFAULT_PORT = "je.rep.defaultPort";
    public static final String NODE_HOST_PORT = "je.rep.nodeHostPort";
    public static final String BIND_INADDR_ANY = "je.rep.bindInaddrAny";
    public static final String CONSISTENCY_POLICY = "je.rep.consistencyPolicy";
    public static final String REP_STREAM_TIMEOUT = "je.rep.repStreamTimeout";
    public static final String REPLAY_COST_PERCENT = "je.rep.replayCostPercent";
    public static final String REPLAY_FREE_DISK_PERCENT = "je.rep.replayFreeDiskPercent";
    public static final String REPLAY_TXN_LOCK_TIMEOUT = "je.rep.replayTxnLockTimeout";
    @Deprecated
    public static final String REPLAY_MAX_OPEN_DB_HANDLES = "je.rep.replayMaxOpenDbHandles";
    @Deprecated
    public static final String REPLAY_DB_HANDLE_TIMEOUT = "je.rep.replayOpenHandleTimeout";
    public static final String ENV_CONSISTENCY_TIMEOUT = "je.rep.envConsistencyTimeout";
    public static final String REPLICA_ACK_TIMEOUT = "je.rep.replicaAckTimeout";
    public static final String INSUFFICIENT_REPLICAS_TIMEOUT = "je.rep.insufficientReplicasTimeout";
    public static final String MAX_MESSAGE_SIZE = "je.rep.maxMessageSize";
    public static final String MAX_CLOCK_DELTA = "je.rep.maxClockDelta";
    public static final String ELECTIONS_PRIMARY_RETRIES = "je.rep.electionsPrimaryRetries";
    public static final String ELECTIONS_REBROADCAST_PERIOD = "je.rep.electionsRebroadcastPeriod";
    public static final String TXN_ROLLBACK_LIMIT = "je.rep.txnRollbackLimit";
    public static final String FEEDER_TIMEOUT = "je.rep.feederTimeout";
    public static final String REPLICA_TIMEOUT = "je.rep.replicaTimeout";
    public static final String REPLICA_RECEIVE_BUFFER_SIZE = "je.rep.replicaReceiveBufferSize";
    public static final String REPLICA_MAX_GROUP_COMMIT = "je.rep.replicaMaxGroupCommit";
    public static final String REPLICA_GROUP_COMMIT_INTERVAL = "je.rep.replicaGroupCommitInterval";
    public static final String ENV_SETUP_TIMEOUT = "je.rep.envSetupTimeout";
    @Deprecated
    public static final String ALLOW_UNKNOWN_STATE_ENV_OPEN = "je.rep.allowUnknownStateEnvOpen";
    public static final String ENV_UNKNOWN_STATE_TIMEOUT = "je.rep.envUnknownStateTimeout";
    public static final String PROTOCOL_OLD_STRING_ENCODING = "je.rep.protocolOldStringEncoding";
    public static final ReplicationConfig DEFAULT = new ReplicationConfig();
    private boolean allowConvert = false;
    private Object repNetConfig = ReplicationNetworkConfig.createDefault();
    private transient ProgressListener<SyncupProgress> syncupProgressListener;
    private transient LogFileRewriteListener logRewriteListener;

    public ReplicationConfig() {
    }

    public ReplicationConfig(String groupName, String nodeName, String hostPort) {
        this.setGroupName(groupName);
        this.setNodeName(nodeName);
        this.setNodeHostPort(hostPort);
    }

    public ReplicationConfig(Properties properties) throws IllegalArgumentException {
        super(properties, true);
        this.propagateRepNetProps();
    }

    ReplicationConfig(Properties properties, boolean validateParams) throws IllegalArgumentException {
        super(properties, validateParams);
        this.propagateRepNetProps();
    }

    public String getGroupName() {
        return DbConfigManager.getVal(this.props, RepParams.GROUP_NAME);
    }

    public ReplicationConfig setGroupName(String groupName) throws IllegalArgumentException {
        this.setGroupNameVoid(groupName);
        return this;
    }

    public void setGroupNameVoid(String groupName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.GROUP_NAME, groupName, this.validateParams);
    }

    boolean getAllowConvert() {
        return this.allowConvert;
    }

    void setAllowConvert(boolean allowConvert) {
        this.allowConvert = allowConvert;
    }

    public String getNodeName() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_NAME);
    }

    public ReplicationConfig setNodeName(String nodeName) throws IllegalArgumentException {
        this.setNodeNameVoid(nodeName);
        return this;
    }

    public void setNodeNameVoid(String nodeName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.NODE_NAME, nodeName, this.validateParams);
    }

    public NodeType getNodeType() {
        return RepParams.NODE_TYPE.getEnumerator(DbConfigManager.getVal(this.props, RepParams.NODE_TYPE));
    }

    public ReplicationConfig setNodeType(NodeType nodeType) {
        this.setNodeTypeVoid(nodeType);
        return this;
    }

    public void setNodeTypeVoid(NodeType nodeType) {
        DbConfigManager.setVal(this.props, RepParams.NODE_TYPE, nodeType.name(), this.validateParams);
    }

    public String getNodeHostPort() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
    }

    public ReplicationConfig setNodeHostPort(String hostPort) {
        this.setNodeHostPortVoid(hostPort);
        return this;
    }

    public void setNodeHostPortVoid(String hostPort) {
        DbConfigManager.setVal(this.props, RepParams.NODE_HOST_PORT, hostPort, this.validateParams);
    }

    public long getReplicaAckTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.REPLICA_ACK_TIMEOUT, unit);
    }

    public ReplicationConfig setReplicaAckTimeout(long replicaAckTimeout, TimeUnit unit) {
        this.setReplicaAckTimeoutVoid(replicaAckTimeout, unit);
        return this;
    }

    public void setReplicaAckTimeoutVoid(long replicaAckTimeout, TimeUnit unit) {
        DbConfigManager.setDurationVal(this.props, RepParams.REPLICA_ACK_TIMEOUT, replicaAckTimeout, unit, this.validateParams);
    }

    public long getMaxClockDelta(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.MAX_CLOCK_DELTA, unit);
    }

    public ReplicationConfig setMaxClockDelta(long maxClockDelta, TimeUnit unit) throws IllegalArgumentException {
        this.setMaxClockDeltaVoid(maxClockDelta, unit);
        return this;
    }

    public void setMaxClockDeltaVoid(long maxClockDelta, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.MAX_CLOCK_DELTA, maxClockDelta, unit, this.validateParams);
    }

    public ReplicationConfig setConsistencyPolicy(ReplicaConsistencyPolicy policy) {
        this.setConsistencyPolicyVoid(policy);
        return this;
    }

    public void setConsistencyPolicyVoid(ReplicaConsistencyPolicy policy) {
        DbConfigManager.setVal(this.props, RepParams.CONSISTENCY_POLICY, RepUtils.getPropertyString(policy), this.validateParams);
    }

    @Override
    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        String propertyValue = DbConfigManager.getVal(this.props, RepParams.CONSISTENCY_POLICY);
        return RepUtils.getReplicaConsistencyPolicy(propertyValue);
    }

    @Override
    public ReplicationConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        if (ReplicationNetworkConfig.getRepNetPropertySet().contains(paramName)) {
            this.getRepNetConfig().setConfigParam(paramName, value);
        } else {
            DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, true, true);
        }
        return this;
    }

    public ReplicationNetworkConfig getRepNetConfig() {
        return (ReplicationNetworkConfig)this.repNetConfig;
    }

    public ReplicationConfig setRepNetConfig(ReplicationNetworkConfig netConfig) {
        this.setRepNetConfigVoid(netConfig);
        return this;
    }

    public void setRepNetConfigVoid(ReplicationNetworkConfig netConfig) {
        if (netConfig == null) {
            throw new IllegalArgumentException("netConfig may not be null");
        }
        this.repNetConfig = netConfig;
    }

    @Override
    public ReplicationConfig clone() {
        try {
            ReplicationConfig copy = (ReplicationConfig)super.clone();
            copy.setRepNetConfig(this.getRepNetConfig().clone());
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void propagateRepNetProps() {
        ReplicationNetworkConfig rnConfig = this.getRepNetConfig();
        if (rnConfig == null) {
            this.setRepNetConfig(ReplicationNetworkConfig.create(this.props));
            return;
        }
        Properties combProps = new Properties(rnConfig.getProps());
        for (String propName : this.props.stringPropertyNames()) {
            combProps.setProperty(propName, this.props.getProperty(propName));
        }
        ReplicationNetworkConfig newRepNetConfig = ReplicationNetworkConfig.create(combProps);
        if (newRepNetConfig.getClass() == this.repNetConfig.getClass()) {
            rnConfig.applyRepNetProperties(combProps);
        } else {
            this.setRepNetConfig(newRepNetConfig);
        }
    }

    public Set<InetSocketAddress> getHelperSockets() {
        return HostPortPair.getSockets(this.getHelperHosts());
    }

    public InetSocketAddress getNodeSocketAddress() {
        return new InetSocketAddress(this.getNodeHostname(), this.getNodePort());
    }

    public String getNodeHostname() {
        String hostAndPort = DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getNodePort() {
        String hostAndPort = DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        String portString = colonToken >= 0 ? hostAndPort.substring(colonToken + 1) : DbConfigManager.getVal(this.props, RepParams.DEFAULT_PORT);
        return Integer.parseInt(portString);
    }

    public ReplicationConfig setSyncupProgressListener(ProgressListener<SyncupProgress> progressListener) {
        this.setSyncupProgressListenerVoid(progressListener);
        return this;
    }

    public void setSyncupProgressListenerVoid(ProgressListener<SyncupProgress> progressListener) {
        this.syncupProgressListener = progressListener;
    }

    public ProgressListener<SyncupProgress> getSyncupProgressListener() {
        return this.syncupProgressListener;
    }

    public ReplicationConfig setLogFileRewriteListener(LogFileRewriteListener listener) {
        this.setLogFileRewriteListenerVoid(listener);
        return this;
    }

    public void setLogFileRewriteListenerVoid(LogFileRewriteListener l) {
        this.logRewriteListener = l;
    }

    public LogFileRewriteListener getLogFileRewriteListener() {
        return this.logRewriteListener;
    }

    public void verify() throws IllegalArgumentException {
        if (this.getGroupName() == null || "".equals(this.getGroupName())) {
            throw new IllegalArgumentException("Missing group name");
        }
        if (this.getNodeName() == null || "".equals(this.getNodeName())) {
            throw new IllegalArgumentException("Missing node name");
        }
        if (this.getNodeHostPort() == null || "".equals(this.getNodeHostPort())) {
            throw new IllegalArgumentException("Missing node host");
        }
    }
}

