/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.rep.ReplicationNode;
import com.tangosol.internal.sleepycat.je.rep.RestartRequiredException;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.util.Set;

public class InsufficientLogException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private final transient RepNode repNode;
    private final VLSN refreshVLSN;
    private final Set<ReplicationNode> logProviders;

    public InsufficientLogException(RepNode repNode, VLSN refreshVLSN, Set<ReplicationNode> logProviders) {
        super(repNode.getRepImpl(), EnvironmentFailureReason.INSUFFICIENT_LOG);
        this.repNode = repNode;
        this.refreshVLSN = refreshVLSN;
        this.logProviders = logProviders;
    }

    private InsufficientLogException(String message, InsufficientLogException cause) {
        super(message, cause);
        this.repNode = cause.getRepNode();
        this.refreshVLSN = cause.getRefreshVLSN();
        this.logProviders = cause.getLogProviders();
    }

    @Override
    public EnvironmentFailureException wrapSelf(String msg) {
        return new InsufficientLogException(msg, this);
    }

    public VLSN getRefreshVLSN() {
        return this.refreshVLSN;
    }

    public Set<ReplicationNode> getLogProviders() {
        return this.logProviders;
    }

    public RepNode getRepNode() {
        return this.repNode;
    }
}

