/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.util.logging.Logger;

public class GroupShutdownException
extends EnvironmentFailureException {
    private static final long serialVersionUID = 1L;
    private final long shutdownTimeMs;
    private final String masterNodeName;
    private final VLSN shutdownVLSN;

    public GroupShutdownException(Logger logger, RepNode repNode, long shutdownTimeMs) {
        super((EnvironmentImpl)repNode.getRepImpl(), EnvironmentFailureReason.SHUTDOWN_REQUESTED, String.format("Master:%s, initiated shutdown at %1tc.", repNode.getMasterStatus().getNodeMasterNameId().getName(), shutdownTimeMs));
        this.shutdownVLSN = repNode.getVLSNIndex().getRange().getLast();
        this.masterNodeName = repNode.getMasterStatus().getNodeMasterNameId().getName();
        this.shutdownTimeMs = shutdownTimeMs;
        LoggerUtils.warning(logger, repNode.getRepImpl(), "Explicit shutdown request from Master:" + this.masterNodeName);
    }

    private GroupShutdownException(String message, GroupShutdownException shutdownException) {
        super(message, shutdownException);
        this.shutdownVLSN = shutdownException.shutdownVLSN;
        this.shutdownTimeMs = shutdownException.shutdownTimeMs;
        this.masterNodeName = shutdownException.masterNodeName;
    }

    @Override
    public GroupShutdownException wrapSelf(String msg) {
        return new GroupShutdownException(msg, this);
    }

    public VLSN getShutdownVLSN() {
        return this.shutdownVLSN;
    }
}

