/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log.entry;

import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.log.Trace;
import com.tangosol.internal.sleepycat.je.log.entry.SingleItemReplicableEntry;
import java.nio.ByteBuffer;

public class TraceLogEntry
extends SingleItemReplicableEntry<Trace> {
    public static final int LAST_FORMAT_CHANGE = 8;
    private static volatile Loggable testPriorItem = null;

    public TraceLogEntry() {
        super(Trace.class);
    }

    public TraceLogEntry(Trace trace) {
        super(LogEntryType.LOG_TRACE, trace);
    }

    public static void setTestPriorItem(Loggable priorItem) {
        testPriorItem = priorItem;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public int getSize(int logVersion) {
        if (testPriorItem != null && logVersion == 7) {
            return testPriorItem.getLogSize();
        }
        return super.getSize(logVersion);
    }

    @Override
    public void writeEntry(ByteBuffer logBuffer, int logVersion) {
        if (testPriorItem != null && logVersion == 7) {
            testPriorItem.writeToLog(logBuffer);
            return;
        }
        super.writeEntry(logBuffer, logVersion);
    }
}

