/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.ChecksumException;
import com.tangosol.internal.sleepycat.je.log.FileReader;
import com.tangosol.internal.sleepycat.je.log.LastFileReader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public abstract class ScavengerFileReader
extends FileReader {
    private Set<Byte> targetEntryTypes;
    private int readBufferSize;
    private boolean dumpCorruptedBounds;

    public ScavengerFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn) throws DatabaseException {
        super(env, readBufferSize, false, startLsn, null, endOfFileLsn, finishLsn);
        this.readBufferSize = readBufferSize;
        this.targetEntryTypes = new HashSet<Byte>();
        this.dumpCorruptedBounds = false;
    }

    public void setDumpCorruptedBounds(boolean dumpCorruptedBounds) {
        this.dumpCorruptedBounds = dumpCorruptedBounds;
    }

    public void setTargetType(LogEntryType type) {
        this.targetEntryTypes.add(type.getTypeNum());
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = lastEntryType.getSharedLogEntry();
        entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        this.processEntryCallback(entry, lastEntryType);
        return true;
    }

    protected abstract void processEntryCallback(LogEntry var1, LogEntryType var2) throws DatabaseException;

    @Override
    public boolean readNextEntry() {
        long saveCurrentEntryOffset = this.currentEntryOffset;
        try {
            return super.readNextEntryAllowExceptions();
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ChecksumException e) {
            this.resyncReader(DbLsn.makeLsn(this.window.currentFileNum(), saveCurrentEntryOffset), this.dumpCorruptedBounds);
            return super.readNextEntry();
        }
    }

    @Override
    protected void handleGapInBackwardsScan(long prevFileNum) {
        if (!this.resyncReader(DbLsn.makeLsn(prevFileNum, 0xFFFFFFFFL), false)) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Cannot read backward over cleaned file from " + this.window.currentFileNum() + " to " + prevFileNum);
        }
    }

    protected boolean resyncReader(long nextGoodRecordPostCorruption, boolean showCorruptedBounds) throws DatabaseException {
        boolean switchedFiles;
        long tryReadBufferFileNum;
        LastFileReader reader = null;
        for (tryReadBufferFileNum = DbLsn.getFileNumber(nextGoodRecordPostCorruption); tryReadBufferFileNum >= 0L; --tryReadBufferFileNum) {
            try {
                reader = new LastFileReader(this.envImpl, this.readBufferSize, tryReadBufferFileNum);
                break;
            }
            catch (ChecksumException e) {
                continue;
            }
        }
        boolean bl = switchedFiles = tryReadBufferFileNum != DbLsn.getFileNumber(nextGoodRecordPostCorruption);
        if (!switchedFiles) {
            while (reader.readNextEntry()) {
            }
        }
        long lastUsedLsn = reader.getLastValidLsn();
        long nextAvailableLsn = reader.getEndOfLog();
        if (showCorruptedBounds) {
            System.err.println("A checksum error was found in the log.");
            System.err.println("Corruption begins at LSN:\n   " + DbLsn.toString(nextAvailableLsn));
            System.err.println("Last known good record before corruption is at LSN:\n   " + DbLsn.toString(lastUsedLsn));
            System.err.println("Next known good record after corruption is at LSN:\n   " + DbLsn.toString(nextGoodRecordPostCorruption));
        }
        this.startLsn = lastUsedLsn;
        this.initStartingPosition(nextAvailableLsn, null);
        if (switchedFiles) {
            this.currentEntryPrevOffset = 0L;
        }
        return true;
    }

    @Override
    protected boolean isTargetEntry() {
        if (this.currentEntryHeader.isInvisible()) {
            return false;
        }
        if (this.targetEntryTypes.size() == 0) {
            return true;
        }
        return this.targetEntryTypes.contains(this.currentEntryHeader.getType());
    }
}

