/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.FileReader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import java.nio.ByteBuffer;

public class CheckpointFileReader
extends FileReader {
    private boolean isDbTree;
    private boolean isCheckpointEnd;
    private boolean isCheckpointStart;

    public CheckpointFileReader(EnvironmentImpl env, int readBufferSize, boolean forward, long startLsn, long finishLsn, long endOfFileLsn) throws DatabaseException {
        super(env, readBufferSize, forward, startLsn, null, endOfFileLsn, finishLsn);
    }

    @Override
    protected boolean isTargetEntry() {
        byte logEntryTypeNumber = this.currentEntryHeader.getType();
        boolean isTarget = false;
        this.isDbTree = false;
        this.isCheckpointEnd = false;
        this.isCheckpointStart = false;
        if (LogEntryType.LOG_CKPT_END.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isCheckpointEnd = true;
        } else if (LogEntryType.LOG_CKPT_START.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isCheckpointStart = true;
        } else if (LogEntryType.LOG_DBTREE.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isDbTree = true;
        }
        return isTarget;
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) {
        return true;
    }

    public boolean isDbTree() {
        return this.isDbTree;
    }

    public boolean isCheckpointEnd() {
        return this.isCheckpointEnd;
    }

    public boolean isCheckpointStart() {
        return this.isCheckpointStart;
    }
}

