/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.dbi;

import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.TriggerUtils;
import com.tangosol.internal.sleepycat.je.log.BasicVersionedWriteLoggable;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ReplicatedDatabaseConfig
extends BasicVersionedWriteLoggable {
    public static final int LAST_FORMAT_CHANGE = 8;
    private byte flags;
    private int maxTreeEntriesPerNode;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[][] triggerBytes = null;

    public ReplicatedDatabaseConfig() {
    }

    ReplicatedDatabaseConfig(byte flags, int maxTreeEntriesPerNode, byte[] btreeComparatorBytes, byte[] duplicateComparatorBytes, byte[][] triggerBytes) {
        this.flags = flags;
        this.maxTreeEntriesPerNode = maxTreeEntriesPerNode;
        if (btreeComparatorBytes != null) {
            this.btreeComparatorBytes = btreeComparatorBytes;
        }
        if (duplicateComparatorBytes != null) {
            this.duplicateComparatorBytes = duplicateComparatorBytes;
        }
        if (triggerBytes != null) {
            this.triggerBytes = triggerBytes;
        }
    }

    public DatabaseConfig getReplicaConfig(EnvironmentImpl envImpl) {
        DatabaseConfig replicaConfig = new DatabaseConfig();
        replicaConfig.setTransactional(true);
        replicaConfig.setSortedDuplicates(DatabaseImpl.getSortedDuplicates(this.flags));
        replicaConfig.setKeyPrefixing(DatabaseImpl.getKeyPrefixing(this.flags) || DatabaseImpl.getSortedDuplicates(this.flags));
        replicaConfig.setTemporary(DatabaseImpl.isTemporary(this.flags));
        replicaConfig.setReplicated(true);
        replicaConfig.setNodeMaxEntries(this.maxTreeEntriesPerNode);
        DatabaseImpl.ComparatorReader reader = new DatabaseImpl.ComparatorReader(this.btreeComparatorBytes, "Btree", envImpl.getClassLoader());
        if (reader.isClass()) {
            replicaConfig.setBtreeComparator(reader.getComparatorClass());
        } else {
            replicaConfig.setBtreeComparator(reader.getComparator());
        }
        reader = new DatabaseImpl.ComparatorReader(this.duplicateComparatorBytes, "Duplicate", envImpl.getClassLoader());
        if (reader.isClass()) {
            replicaConfig.setDuplicateComparator(reader.getComparatorClass());
        } else {
            replicaConfig.setDuplicateComparator(reader.getComparator());
        }
        replicaConfig.setTriggers(TriggerUtils.unmarshallTriggers(null, this.triggerBytes, envImpl.getClassLoader()));
        return replicaConfig;
    }

    @Override
    public int getLogSize() {
        return 1 + LogUtils.getPackedIntLogSize(this.maxTreeEntriesPerNode) + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes) + TriggerUtils.logSize(this.triggerBytes);
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        logBuffer.put(this.flags);
        LogUtils.writePackedInt(logBuffer, this.maxTreeEntriesPerNode);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
        TriggerUtils.writeTriggers(logBuffer, this.triggerBytes);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.flags = itemBuffer.get();
        this.maxTreeEntriesPerNode = LogUtils.readInt(itemBuffer, false);
        if (entryVersion < 8) {
            LogUtils.readInt(itemBuffer, false);
        }
        this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer, false);
        this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer, false);
        this.triggerBytes = entryVersion < 8 ? (byte[][])null : TriggerUtils.readTriggers(itemBuffer, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<config ");
        DatabaseImpl.dumpFlags(sb, verbose, this.flags);
        sb.append(" btcmpSet=\"").append(this.btreeComparatorBytes != LogUtils.ZERO_LENGTH_BYTE_ARRAY);
        sb.append("\" dupcmpSet=\"").append(this.duplicateComparatorBytes != LogUtils.ZERO_LENGTH_BYTE_ARRAY).append("\"");
        TriggerUtils.dumpTriggers(sb, this.triggerBytes, null);
        sb.append(" />");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof ReplicatedDatabaseConfig)) {
            return false;
        }
        ReplicatedDatabaseConfig otherConfig = (ReplicatedDatabaseConfig)other;
        if (this.flags != otherConfig.flags) {
            return false;
        }
        if (this.maxTreeEntriesPerNode != otherConfig.maxTreeEntriesPerNode) {
            return false;
        }
        if (!Arrays.equals(this.btreeComparatorBytes, otherConfig.btreeComparatorBytes)) {
            return false;
        }
        return Arrays.equals(this.duplicateComparatorBytes, otherConfig.duplicateComparatorBytes);
    }
}

