/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.dbi;

import com.tangosol.internal.sleepycat.je.CacheMode;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.cleaner.DbFileSummary;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DupKeyData;
import com.tangosol.internal.sleepycat.je.dbi.LSNAccumulator;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogManager;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.log.entry.LNLogEntry;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import com.tangosol.internal.sleepycat.je.tree.BIN;
import com.tangosol.internal.sleepycat.je.tree.IN;
import com.tangosol.internal.sleepycat.je.tree.Key;
import com.tangosol.internal.sleepycat.je.tree.LN;
import com.tangosol.internal.sleepycat.je.tree.OldBINDelta;
import com.tangosol.internal.sleepycat.je.tree.SearchResult;
import com.tangosol.internal.sleepycat.je.tree.Tree;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class DiskOrderedScanner {
    private static final LogEntryType[] LN_ONLY = new LogEntryType[]{LogEntryType.LOG_INS_LN};
    private static final LogEntryType[] BIN_ONLY = new LogEntryType[]{LogEntryType.LOG_BIN};
    private static final LogEntryType[] BIN_OR_DELTA = new LogEntryType[]{LogEntryType.LOG_BIN, LogEntryType.LOG_BIN_DELTA, LogEntryType.LOG_OLD_BIN_DELTA};
    private final DatabaseImpl dbImpl;
    private final boolean dupDb;
    private final boolean countOnly;
    private final boolean keysOnly;
    private final boolean binsOnly;
    private final long lsnBatchSize;
    private final long memoryLimit;
    private final RecordProcessor processor;
    private final Map<Long, DbFileSummary> dbFileSummaries;
    private final LSNAccumulator lsnAcc;
    private long memoryUsage;
    private byte[] prevEndingKey;
    private byte[] newEndingKey;
    private volatile int nIterations;

    DiskOrderedScanner(DatabaseImpl dbImpl, RecordProcessor processor, boolean keysOnly, boolean countOnly, long lsnBatchSize, long memoryLimit) {
        this.dbImpl = dbImpl;
        this.processor = processor;
        this.dupDb = dbImpl.getSortedDuplicates();
        this.countOnly = countOnly;
        this.keysOnly = keysOnly || countOnly;
        this.binsOnly = this.dupDb || keysOnly || countOnly;
        this.lsnBatchSize = lsnBatchSize;
        this.memoryLimit = memoryLimit;
        this.dbFileSummaries = dbImpl.cloneDbFileSummaries();
        this.lsnAcc = new LSNAccumulator(){

            @Override
            void noteMemUsage(long increment) {
                DiskOrderedScanner.this.addMemoryUsage(increment);
            }
        };
    }

    private void addMemoryUsage(long increment) {
        this.memoryUsage += increment;
    }

    int getNIterations() {
        return this.nIterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        while (true) {
            IN in = this.getFirstIN();
            ArrayList<BIN> binDeltas = this.binsOnly ? new ArrayList<BIN>(500) : null;
            try {
                while (in != null) {
                    if (this.binsOnly) {
                        this.accumulateBINs(in, binDeltas);
                    } else {
                        this.accumulateLNs(in);
                    }
                    if (this.accLimitExceeded()) {
                        break;
                    }
                    IN prevIn = in;
                    in = null;
                    in = this.getNextIN(prevIn);
                }
            }
            finally {
                if (in != null) {
                    in.releaseLatch();
                }
            }
            long[] lsnArray = this.lsnAcc.getAndSortPendingLSNs();
            if (this.binsOnly) {
                this.fetchAndProcessBINs(lsnArray, binDeltas);
            } else {
                this.fetchAndProcessLNs(lsnArray);
            }
            ++this.nIterations;
            if (in == null) break;
            this.lsnAcc.clear();
            this.memoryUsage = 0L;
            this.prevEndingKey = this.newEndingKey;
        }
    }

    private boolean accLimitExceeded() {
        return this.memoryUsage >= this.memoryLimit || (long)this.lsnAcc.getNTotalEntries() > this.lsnBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateBINs(IN parent, List<BIN> binDeltas) {
        for (int i = 0; i < parent.getNEntries(); ++i) {
            if (i + 1 < parent.getNEntries() && this.prevEndingKey != null && Key.compareKeys(this.prevEndingKey, parent.getKey(i + 1), this.dbImpl.getKeyComparator()) >= 0) continue;
            if (this.accLimitExceeded()) {
                return;
            }
            long binLsn = parent.getLsn(i);
            BIN bin = (BIN)parent.getTarget(i);
            if (bin != null) {
                bin.latch();
            }
            try {
                if (bin != null && bin.isBINDelta()) {
                    BIN delta = bin.cloneBINDelta();
                    binDeltas.add(delta);
                    this.addMemoryUsage(delta.getInMemorySize());
                    continue;
                }
                if (bin == null || !this.processor.neverBlocks() && !bin.getDirty() || !this.processor.canProcessWithoutBlocking(bin.getNEntries())) {
                    this.lsnAcc.add(binLsn);
                    this.addMemoryUsage(this.getDeltaMemSize(DbLsn.getFileNumber(binLsn)));
                    continue;
                }
                for (int j = 0; j < bin.getNEntries(); ++j) {
                    if (this.skipSlot(bin, j)) continue;
                    this.processRecord(bin.getKey(j), null);
                }
                continue;
            }
            finally {
                if (bin != null) {
                    bin.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateLNs(IN parent) {
        for (int i = 0; i < parent.getNEntries(); ++i) {
            if (i + 1 < parent.getNEntries() && this.prevEndingKey != null && Key.compareKeys(this.prevEndingKey, parent.getKey(i + 1), this.dbImpl.getKeyComparator()) >= 0) continue;
            if (this.accLimitExceeded()) {
                return;
            }
            boolean isLatched = false;
            BIN bin = (BIN)parent.getTarget(i);
            if (bin == null) {
                Object item = this.fetchItem(parent.getLsn(i), BIN_OR_DELTA);
                if (item instanceof BIN) {
                    bin = (BIN)item;
                    if (bin.isBINDelta(false)) {
                        bin = bin.reconstituteBIN(this.dbImpl);
                    } else {
                        bin.setDatabase(this.dbImpl);
                    }
                } else {
                    OldBINDelta delta = (OldBINDelta)item;
                    bin = (BIN)this.fetchItem(delta.getLastFullLsn(), BIN_ONLY);
                    delta.reconstituteBIN(this.dbImpl, bin);
                }
            } else {
                BIN fullBIN = null;
                bin.latch();
                isLatched = true;
                try {
                    if (bin.isBINDelta()) {
                        fullBIN = bin.reconstituteBIN(this.dbImpl);
                    }
                }
                finally {
                    if (bin.isBINDelta()) {
                        bin.releaseLatch();
                        bin = fullBIN;
                        isLatched = false;
                    }
                }
            }
            try {
                for (int j = 0; j < bin.getNEntries(); ++j) {
                    if (this.skipSlot(bin, j)) continue;
                    LN ln = (LN)bin.getTarget(j);
                    if (ln == null || this.dbImpl.isDeferredWriteMode() && !ln.isDirty() || !this.processor.canProcessWithoutBlocking(1)) {
                        if (DbLsn.isTransientOrNull(bin.getLsn(j))) continue;
                        this.lsnAcc.add(bin.getLsn(j));
                        continue;
                    }
                    this.processRecord(bin.getKey(j), ln.getData());
                }
                continue;
            }
            finally {
                if (isLatched) {
                    bin.releaseLatch();
                }
            }
        }
    }

    private void fetchAndProcessBINs(long[] lsnArray, List<BIN> binDeltas) {
        BIN bin;
        int i;
        int nDeltas = binDeltas.size();
        Object[] deltaArray = new Object[nDeltas + lsnArray.length];
        for (i = 0; i < nDeltas; ++i) {
            deltaArray[i] = binDeltas.get(i);
        }
        binDeltas.clear();
        for (i = 0; i < lsnArray.length; ++i) {
            Object item = this.fetchItem(lsnArray[i], BIN_OR_DELTA);
            if (item instanceof OldBINDelta) {
                deltaArray[nDeltas] = item;
                ++nDeltas;
                continue;
            }
            bin = (BIN)item;
            if (bin.isBINDelta(false)) {
                deltaArray[nDeltas] = item;
                ++nDeltas;
                continue;
            }
            bin.setDatabase(this.dbImpl);
            this.processBIN(bin);
        }
        if (nDeltas == 0) {
            return;
        }
        Arrays.sort(deltaArray, 0, nDeltas, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return DbLsn.compareTo(this.getLsn(a), this.getLsn(b));
            }

            private long getLsn(Object o) {
                if (o instanceof OldBINDelta) {
                    return ((OldBINDelta)o).getLastFullLsn();
                }
                return ((BIN)o).getLastFullVersion();
            }
        });
        for (i = 0; i < nDeltas; ++i) {
            Loggable delta;
            Object o = deltaArray[i];
            if (o instanceof OldBINDelta) {
                delta = (OldBINDelta)o;
                bin = (BIN)this.fetchItem(((OldBINDelta)delta).getLastFullLsn(), BIN_ONLY);
                ((OldBINDelta)delta).reconstituteBIN(this.dbImpl, bin);
            } else {
                delta = (BIN)o;
                bin = ((BIN)delta).reconstituteBIN(this.dbImpl);
            }
            this.processBIN(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBIN(BIN bin) {
        bin.latch();
        try {
            for (int i = 0; i < bin.getNEntries(); ++i) {
                if (this.skipSlot(bin, i)) continue;
                this.processRecord(bin.getKey(i), null);
            }
        }
        finally {
            bin.releaseLatch();
        }
    }

    private void fetchAndProcessLNs(long[] lsnArray) {
        for (int i = 0; i < lsnArray.length; ++i) {
            LNLogEntry entry = (LNLogEntry)this.fetchEntry(lsnArray[i], LN_ONLY);
            entry.postFetchInit(this.dbImpl);
            LN ln = entry.getMainItem();
            if (ln.isDeleted()) continue;
            this.processRecord(entry.getKey(), ln.getData());
        }
    }

    private void processRecord(byte[] treeKey, byte[] treeData) {
        byte[] data;
        byte[] key;
        if (this.dupDb && !this.countOnly) {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = this.keysOnly ? null : new DatabaseEntry();
            DupKeyData.split(treeKey, treeKey.length, keyEntry, dataEntry);
            key = keyEntry.getData();
            data = this.keysOnly ? null : dataEntry.getData();
        } else {
            key = this.countOnly ? null : treeKey;
            data = this.keysOnly ? null : treeData;
        }
        this.processor.process(key, data);
        if (this.newEndingKey == null || Key.compareKeys(this.newEndingKey, treeKey, this.dbImpl.getKeyComparator()) < 0) {
            this.newEndingKey = treeKey;
        }
    }

    private Object fetchItem(long lsn, LogEntryType[] expectTypes) {
        return this.fetchEntry(lsn, expectTypes).getMainItem();
    }

    private LogEntry fetchEntry(long lsn, LogEntryType[] expectTypes) {
        LogManager logManager = this.dbImpl.getEnv().getLogManager();
        LogEntry entry = logManager.getLogEntryHandleFileNotFound(lsn);
        LogEntryType type = entry.getLogType();
        for (int i = 0; i < expectTypes.length; ++i) {
            if (!(expectTypes[i].isLNType() ? type.isLNType() : type.equals(expectTypes[i]))) continue;
            return entry;
        }
        throw EnvironmentFailureException.unexpectedState("Expected: " + Arrays.toString(expectTypes) + " but got: " + type + " LSN=" + DbLsn.getNoFormatString(lsn));
    }

    private int getDeltaMemSize(long fileNum) {
        DbFileSummary summary = this.dbFileSummaries.get(fileNum);
        if (summary == null) {
            return 0;
        }
        float avgINSize = (float)summary.totalINSize / (float)summary.totalINCount;
        return (int)(avgINSize * 2.0f);
    }

    private boolean skipSlot(BIN bin, int index) {
        if (bin.isEntryPendingDeleted(index) || bin.isEntryKnownDeleted(index)) {
            return true;
        }
        return this.prevEndingKey != null && Key.compareKeys(this.prevEndingKey, bin.getKey(index), this.dbImpl.getKeyComparator()) >= 0;
    }

    private IN getFirstIN() {
        Tree tree = this.dbImpl.getTree();
        for (int i = 0; i < 25; ++i) {
            BIN bin = this.prevEndingKey == null ? tree.getFirstNode(CacheMode.UNCHANGED) : tree.search(this.prevEndingKey, CacheMode.UNCHANGED);
            if (bin == null) {
                return null;
            }
            SearchResult result = tree.getParentINForChildIN(bin, false, true, CacheMode.UNCHANGED);
            IN parent = result.parent;
            if (!result.exactParentFound) {
                if (parent == null) continue;
                parent.releaseLatch();
                continue;
            }
            return parent;
        }
        throw EnvironmentFailureException.unexpectedState("Unable to find BIN for prevEndingKey: " + Arrays.toString(this.prevEndingKey));
    }

    private IN getNextIN(IN prevIn) {
        return this.dbImpl.getTree().getNextIN(prevIn, true, CacheMode.UNCHANGED);
    }

    static interface RecordProcessor {
        public void process(byte[] var1, byte[] var2);

        public boolean canProcessWithoutBlocking(int var1);

        public boolean neverBlocks();
    }
}

