/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.cleaner;

import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.MemoryBudget;
import com.tangosol.internal.sleepycat.je.tree.LN;

public final class LNInfo {
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;

    public LNInfo(LN ln, DatabaseId dbId, byte[] key) {
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
    }

    LN getLN() {
        return this.ln;
    }

    DatabaseId getDbId() {
        return this.dbId;
    }

    byte[] getKey() {
        return this.key;
    }

    int getMemorySize() {
        int size = MemoryBudget.LN_INFO_OVERHEAD;
        if (this.ln != null) {
            size = (int)((long)size + this.ln.getMemorySizeIncludedByParent());
        }
        if (this.key != null) {
            size += MemoryBudget.byteArraySize(this.key.length);
        }
        return size;
    }
}

