/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursor;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.EnvironmentConfig;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.EnvironmentMutableConfig;
import com.tangosol.internal.sleepycat.je.ExceptionEvent;
import com.tangosol.internal.sleepycat.je.JoinCursor;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.Transaction;
import com.tangosol.internal.sleepycat.je.TransactionConfig;
import com.tangosol.internal.sleepycat.je.dbi.CursorImpl;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DiskOrderedCursorImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.GetMode;
import com.tangosol.internal.sleepycat.je.dbi.PutMode;
import com.tangosol.internal.sleepycat.je.log.ReplicationContext;
import com.tangosol.internal.sleepycat.je.tree.LN;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.Txn;
import com.tangosol.internal.sleepycat.util.keyrange.KeyRange;
import com.tangosol.internal.sleepycat.util.keyrange.RangeCursor;
import java.io.File;
import java.util.Properties;

public class DbInternal {
    public static void invalidate(Database db) {
        db.invalidate();
    }

    public static void setPreempted(Database db, String dbName, String msg) {
        db.setPreempted(dbName, msg);
    }

    public static EnvironmentImpl getEnvironmentImpl(Environment env) {
        return env.getEnvironmentImpl();
    }

    public static void closeInternalHandle(Environment env) {
        env.closeInternalHandle();
    }

    public static OperationStatus position(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        return cursor.position(key, data, lockMode, first);
    }

    public static OperationStatus search(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        return cursor.search(key, data, lockMode, searchMode);
    }

    public static OperationStatus searchForReplay(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        return cursor.searchForReplay(key, data, lockMode, searchMode);
    }

    public static OperationStatus retrieveNext(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) throws DatabaseException {
        return cursor.retrieveNext(key, data, lockMode, getMode);
    }

    public static boolean advanceCursor(Cursor cursor, DatabaseEntry key, DatabaseEntry data) {
        return cursor.advanceCursor(key, data);
    }

    public static OperationStatus deleteInternal(Cursor cursor, ReplicationContext repContext) {
        return cursor.deleteInternal(repContext);
    }

    public static OperationStatus putForReplay(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, ReplicationContext repContext) {
        return cursor.putForReplay(key, data, ln, putMode, repContext);
    }

    public static OperationStatus search(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, LockMode lockMode) {
        OperationStatus status;
        boolean first;
        DatabaseImpl dbImpl = cursor.getDatabaseImpl();
        KeyRange range = new KeyRange(dbImpl.getBtreeComparator());
        switch (searchMode) {
            case GT: 
            case GTE: {
                range = range.subRange(key, searchMode == Search.GTE, null, false);
                first = true;
                break;
            }
            case LT: 
            case LTE: {
                range = range.subRange(null, false, key, searchMode == Search.LTE);
                first = false;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState();
            }
        }
        RangeCursor rangeCursor = new RangeCursor(range, null, dbImpl.getSortedDuplicates(), cursor);
        OperationStatus operationStatus = status = first ? rangeCursor.getFirst(key, pKey, data, lockMode) : rangeCursor.getLast(key, pKey, data, lockMode);
        assert (cursor == rangeCursor.getCursor());
        return status;
    }

    public static OperationStatus searchBoth(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, LockMode lockMode) {
        OperationStatus status;
        boolean first;
        DatabaseImpl dbImpl = cursor.getDatabaseImpl();
        KeyRange range = new KeyRange(dbImpl.getBtreeComparator());
        range = range.subRange(key);
        KeyRange pKeyRange = new KeyRange(dbImpl.getDuplicateComparator());
        switch (searchMode) {
            case GT: 
            case GTE: {
                pKeyRange = pKeyRange.subRange(pKey, searchMode == Search.GTE, null, false);
                first = true;
                break;
            }
            case LT: 
            case LTE: {
                pKeyRange = pKeyRange.subRange(null, false, pKey, searchMode == Search.LTE);
                first = false;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState();
            }
        }
        RangeCursor rangeCursor = new RangeCursor(range, pKeyRange, dbImpl.getSortedDuplicates(), cursor);
        OperationStatus operationStatus = status = first ? rangeCursor.getFirst(key, pKey, data, lockMode) : rangeCursor.getLast(key, pKey, data, lockMode);
        assert (cursor == rangeCursor.getCursor());
        return status;
    }

    public static CursorImpl getCursorImpl(Cursor cursor) {
        return cursor.getCursorImpl();
    }

    public static Cursor makeCursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig) {
        Cursor cursor = new Cursor(databaseImpl, locker, cursorConfig, true);
        cursor.setNonSticky(true);
        return cursor;
    }

    public static void setNonCloning(Cursor cursor, boolean nonSticky) {
        cursor.setNonSticky(nonSticky);
    }

    public static DatabaseImpl getDatabaseImpl(Database db) {
        return db.getDatabaseImpl();
    }

    public static Cursor[] getSortedCursors(JoinCursor cursor) {
        return cursor.getSortedCursors();
    }

    public static void setLoadPropertyFile(EnvironmentConfig config, boolean loadProperties) {
        config.setLoadPropertyFile(loadProperties);
    }

    public static void setCreateUP(EnvironmentConfig config, boolean checkpointUP) {
        config.setCreateUP(checkpointUP);
    }

    public static boolean getCreateUP(EnvironmentConfig config) {
        return config.getCreateUP();
    }

    public static void setCheckpointUP(EnvironmentConfig config, boolean checkpointUP) {
        config.setCheckpointUP(checkpointUP);
    }

    public static boolean getCheckpointUP(EnvironmentConfig config) {
        return config.getCheckpointUP();
    }

    public static void setTxnReadCommitted(EnvironmentConfig config, boolean txnReadCommitted) {
        config.setTxnReadCommitted(txnReadCommitted);
    }

    public static boolean getTxnReadCommitted(EnvironmentConfig config) {
        return config.getTxnReadCommitted();
    }

    public static EnvironmentMutableConfig cloneMutableConfig(EnvironmentMutableConfig config) {
        return config.cloneMutableConfig();
    }

    public static void checkImmutablePropsForEquality(EnvironmentMutableConfig config, Properties handleConfigProps) throws IllegalArgumentException {
        config.checkImmutablePropsForEquality(handleConfigProps);
    }

    public static void copyMutablePropsTo(EnvironmentMutableConfig config, EnvironmentMutableConfig toConfig) {
        config.copyMutablePropsTo(toConfig);
    }

    public static void disableParameterValidation(EnvironmentMutableConfig config) {
        config.setValidateParams(false);
    }

    public static Properties getProps(EnvironmentMutableConfig config) {
        return config.getProps();
    }

    public static void setUseExistingConfig(DatabaseConfig config, boolean useExistingConfig) {
        config.setUseExistingConfig(useExistingConfig);
    }

    public static void validate(DatabaseConfig config1, DatabaseConfig config2) throws DatabaseException {
        config1.validate(config2);
    }

    public static Locker getLocker(Transaction txn) throws DatabaseException {
        return txn.getLocker();
    }

    public static Environment getEnvironment(Transaction txn) throws DatabaseException {
        return txn.getEnvironment();
    }

    public static TransactionConfig getDefaultTxnConfig(Environment env) {
        return env.getDefaultTxnConfig();
    }

    public static Environment getEnvironmentShell(File environmentHome) {
        Environment env = new Environment(environmentHome);
        if (env.isValid()) {
            return env;
        }
        return null;
    }

    public static Database openInternalDatabase(Environment env, Transaction txn, String databaseName, DatabaseConfig config) {
        return env.openInternalDatabase(txn, databaseName, config);
    }

    public static Transaction beginInternalTransaction(Environment env, TransactionConfig config) {
        return env.beginInternalTransaction(config);
    }

    public static ExceptionEvent makeExceptionEvent(Exception e, String n) {
        return new ExceptionEvent(e, n);
    }

    public static Txn getTxn(Transaction transaction) {
        return transaction.getTxn();
    }

    public static DiskOrderedCursorImpl getDiskOrderedCursorImpl(DiskOrderedCursor cursor) {
        return cursor.getCursorImpl();
    }

    public static enum Search {
        GT,
        GTE,
        LT,
        LTE;

    }
}

