/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.collections;

import com.tangosol.internal.sleepycat.collections.DataView;
import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.util.keyrange.KeyRange;
import com.tangosol.internal.sleepycat.util.keyrange.RangeCursor;

class MyRangeCursor
extends RangeCursor {
    private DataView view;
    private boolean isRecnoOrQueue;
    private boolean writeCursor;

    MyRangeCursor(KeyRange range, CursorConfig config, DataView view, boolean writeAllowed) throws DatabaseException {
        super(range, view.dupsRange, view.dupsOrdered, MyRangeCursor.openCursor(view, config, writeAllowed));
        this.view = view;
        this.isRecnoOrQueue = view.recNumAllowed && !view.btreeRecNumDb;
        this.writeCursor = MyRangeCursor.isWriteCursor(config, writeAllowed);
    }

    private static boolean isWriteCursor(CursorConfig config, boolean writeAllowed) {
        return DbCompat.getWriteCursor(config) || config == CursorConfig.DEFAULT && writeAllowed;
    }

    private static Cursor openCursor(DataView view, CursorConfig config, boolean writeAllowed) throws DatabaseException {
        return view.currentTxn.openCursor(view.db, config, MyRangeCursor.isWriteCursor(config, writeAllowed), view.useTransaction());
    }

    @Override
    protected Cursor dupCursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        return this.view.currentTxn.dupCursor(cursor, this.writeCursor, samePosition);
    }

    @Override
    protected void closeCursor(Cursor cursor) throws DatabaseException {
        this.view.currentTxn.closeCursor(cursor);
    }

    @Override
    protected boolean checkRecordNumber() {
        return this.isRecnoOrQueue;
    }
}

