/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.util.UtfOps;

public class StringBinding
extends TupleBinding<String> {
    @Override
    public String entryToObject(TupleInput input) {
        return input.readString();
    }

    @Override
    public void objectToEntry(String object, TupleOutput output) {
        output.writeString(object);
    }

    @Override
    protected TupleOutput getTupleOutput(String object) {
        return StringBinding.sizedOutput(object);
    }

    public static String entryToString(DatabaseEntry entry) {
        return StringBinding.entryToInput(entry).readString();
    }

    public static void stringToEntry(String val, DatabaseEntry entry) {
        StringBinding.outputToEntry(StringBinding.sizedOutput(val).writeString(val), entry);
    }

    private static TupleOutput sizedOutput(String val) {
        int stringLength = val == null ? 1 : UtfOps.getByteLength(val.toCharArray());
        return new TupleOutput(new byte[++stringLength]);
    }
}

