/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import java.math.BigDecimal;

public class SortedBigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput input) {
        return input.readSortedBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal object, TupleOutput output) {
        output.writeSortedBigDecimal(object);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal object) {
        return SortedBigDecimalBinding.sizedOutput(object);
    }

    public static BigDecimal entryToBigDecimal(DatabaseEntry entry) {
        return SortedBigDecimalBinding.entryToInput(entry).readSortedBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal val, DatabaseEntry entry) {
        SortedBigDecimalBinding.outputToEntry(SortedBigDecimalBinding.sizedOutput(val).writeSortedBigDecimal(val), entry);
    }

    private static TupleOutput sizedOutput(BigDecimal val) {
        int len = TupleOutput.getSortedBigDecimalMaxByteLength(val);
        return new TupleOutput(new byte[len]);
    }
}

