/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;

public class FloatBinding
extends TupleBinding<Float> {
    private static final int FLOAT_SIZE = 4;

    @Override
    public Float entryToObject(TupleInput input) {
        return Float.valueOf(input.readFloat());
    }

    @Override
    public void objectToEntry(Float object, TupleOutput output) {
        output.writeFloat(object.floatValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Float object) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(DatabaseEntry entry) {
        return FloatBinding.entryToInput(entry).readFloat();
    }

    public static void floatToEntry(float val, DatabaseEntry entry) {
        FloatBinding.outputToEntry(FloatBinding.sizedOutput().writeFloat(val), entry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

