/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.statistics;

import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.internal.net.topic.impl.paged.management.PolledMetrics;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.statistics.SubscriberGroupChannelStatistics;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SubscriberGroupStatistics
implements PolledMetrics {
    private final LongArray<SubscriberGroupChannelStatistics> m_aChannelStats = new SimpleLongArray();
    private final Lock f_lock = new ReentrantLock(true);
    private final Meter f_metricPolled = new Meter();

    public SubscriberGroupStatistics(int cChannel) {
        for (int i = 0; i < cChannel; ++i) {
            this.m_aChannelStats.set(i, new SubscriberGroupChannelStatistics(i));
        }
    }

    public SubscriberGroupChannelStatistics getChannelStatistics(int nChannel) {
        SubscriberGroupChannelStatistics statistics = this.m_aChannelStats.get(nChannel);
        if (statistics == null) {
            this.f_lock.lock();
            try {
                statistics = new SubscriberGroupChannelStatistics(nChannel);
                this.m_aChannelStats.set(nChannel, statistics);
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return statistics;
    }

    public void onPolled(int nChannel, long cMessage, PagedPosition head) {
        this.f_metricPolled.mark(cMessage);
        this.getChannelStatistics(nChannel).onPolled(cMessage, head);
    }

    public void onCommitted(int nChannel, PagedPosition committedPosition) {
        this.getChannelStatistics(nChannel).onCommitted(committedPosition);
    }

    public void setOwningSubscriber(int nChannel, SubscriberId nOwningSubscriber) {
        this.getChannelStatistics(nChannel).setOwningSubscriber(nOwningSubscriber);
    }

    @Override
    public long getPolledCount() {
        return this.f_metricPolled.getCount();
    }

    @Override
    public double getPolledFifteenMinuteRate() {
        return this.f_metricPolled.getFifteenMinuteRate();
    }

    @Override
    public double getPolledFiveMinuteRate() {
        return this.f_metricPolled.getFiveMinuteRate();
    }

    @Override
    public double getPolledOneMinuteRate() {
        return this.f_metricPolled.getOneMinuteRate();
    }

    @Override
    public double getPolledMeanRate() {
        return this.f_metricPolled.getMeanRate();
    }
}

